"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.hvigor=exports.getHvigorConfigValue=exports.getNode=exports.getHvigorNode=void 0;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),const_js_1=require("../../../common/const/const.js"),queue_js_1=require("../../../common/util/queue.js"),tree_node_js_1=require("../../../common/util/tree-node.js"),common_const_js_1=require("../../common/options/common-const.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),file_util_js_1=require("../../util/file-util.js"),json5_reader_js_1=require("../../util/json5-reader.js"),hvigor_node_impl_js_1=require("../../vigor/plugin/impl/hvigor-node-impl.js"),_log=hvigor_log_js_1.HvigorLogger.getLogger("hvigor");class Hvigor{constructor(){this._beforeAllNodesEvaluatedActions=new queue_js_1.Queue,this._hvigorNodesEvaluatedActionQueue=new queue_js_1.Queue,this._project=void 0,this._extraConfig=new Map,this._scriptMap=new Map}getProject(){return this._project}getModuleByScriptPath(e){return this._scriptMap.get(e)}getHvigorNodeByScriptPath(e){var o;return null===(o=this._hvigorNodeTree.findNodeByKeyBFS(e))||void 0===o?void 0:o.value}getParentNodeByScriptPath(e){var o;return null===(o=this._hvigorNodeTree.findParentNodeByKey(e))||void 0===o?void 0:o.value}getSubNodeByScriptPath(e){var o;return null===(o=this._hvigorNodeTree.findNodeByKeyBFS(e))||void 0===o?void 0:o.children.map((e=>e.value))}getExtraConfig(){return this._extraConfig}setExtraConfig(e){this._extraConfig=e}isCommandEntryTask(e){return!!this._commandEntryTasks&&this._commandEntryTasks.includes(e)}setCommandEntryTasks(e){this._commandEntryTasks=e}initRootProject(e){this._project=e,this._scriptMap.set(e.getBuildFilePath(),this._project);const o=new hvigor_node_impl_js_1.HvigorNodeImpl(this._project);this._hvigorNodeTree=new tree_node_js_1.Tree(e.getBuildFilePath(),o),this.initSubModules(e.getAllSubModules())}initSubModules(e){e.forEach((e=>{this._scriptMap.set(e.getBuildFilePath(),e),this._hvigorNodeTree.addNode(e.getBuildFilePath(),new hvigor_node_impl_js_1.HvigorNodeImpl(e),this._project.getBuildFilePath())}))}checkProjectConfigFile(e){Array.isArray(e)||_log.errorMessageExit(`'modules' property should be an array in root project ${common_const_js_1.HvigorCommonConst.PROJECT_CONFIG_FILE}\n                at ${path_1.default.resolve(this._project.getNodeDir(),common_const_js_1.HvigorCommonConst.PROJECT_CONFIG_FILE)}`),e&&0!==e.length||_log.errorMessageExit(`No modules found, Please check root project ${common_const_js_1.HvigorCommonConst.PROJECT_CONFIG_FILE}\n                at ${path_1.default.resolve(this._project.getNodeDir(),common_const_js_1.HvigorCommonConst.PROJECT_CONFIG_FILE)}`)}nodesEvaluated(e){this._hvigorNodesEvaluatedActionQueue.push(e)}beforeNodesEvaluated(e){this._beforeAllNodesEvaluatedActions.push(e)}getNodesEvaluatedActionQueue(){return this._hvigorNodesEvaluatedActionQueue}getBeforceAllNodesEvaluatedActions(){return this._beforeAllNodesEvaluatedActions}reset(){var e,o,t,r;const i=new Set;i.add((0,file_util_js_1.findRealHvigorFilePath)(null===(e=this._project)||void 0===e?void 0:e.getBuildFilePath())),null===(o=this._project)||void 0===o||o.getAllSubModules().forEach((e=>{i.add((0,file_util_js_1.findRealHvigorFilePath)(e.getBuildFilePath()))})),i.forEach((e=>{if(!e)return;const o=require(e);if(o)for(const e of Object.keys(o))"object"==typeof o[e]&&(o[e]=void 0)})),this._extraConfig.clear(),this._scriptMap.clear(),this._hvigorNodesEvaluatedActionQueue.clear(),this._beforeAllNodesEvaluatedActions.clear(),null===(t=this._project)||void 0===t||t.getAllSubModules().forEach((e=>{e.getTaskContainer().clearTasks(),e.clearTaskGraph()})),null===(r=this._project)||void 0===r||r.getTaskContainer().clearTasks(),this._project=void 0,this._commandEntryTasks=void 0}}function getHvigorNode(e){return e?exports.hvigor.getModuleByScriptPath(e.substring(0,e.lastIndexOf("."))):exports.hvigor.getProject()}function getNode(e){const o=e?e.substring(0,e.lastIndexOf(".")):exports.hvigor.getProject().getBuildFilePath();return exports.hvigor.getHvigorNodeByScriptPath(o)}function getHvigorConfigValue(e){const o=path_1.default.resolve(const_js_1.HVIGOR_PROJECT_WRAPPER_HOME,const_js_1.DEFAULT_HVIGOR_CONFIG_JSON_FILE_NAME);if(!fs_1.default.existsSync(o))return!1;const t=json5_reader_js_1.Json5Reader.getJson5Obj(o),r=json5_reader_js_1.Json5Reader.getJson5ObjProp(t,e);if(t&&void 0!==r)return!1===r;{const o=path_1.default.resolve(const_js_1.HVIGOR_USER_HOME,const_js_1.DEFAULT_HVIGOR_CONFIG_JSON_FILE_NAME);if(!fs_1.default.existsSync(o))return!1;const t=json5_reader_js_1.Json5Reader.getJson5Obj(o),r=json5_reader_js_1.Json5Reader.getJson5ObjProp(t,e);if(t&&void 0!==r)return!1===r}return!1}exports.getHvigorNode=getHvigorNode,exports.getNode=getNode,exports.getHvigorConfigValue=getHvigorConfigValue,exports.hvigor=new Hvigor;