"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.configuration=void 0;const cluster_1=__importDefault(require("cluster")),path_1=__importDefault(require("path")),process_1=__importDefault(require("process")),common_const_js_1=require("../../common/options/common-const.js"),watch_config_file_js_1=require("../../daemon/cluster/watch-config-file.js"),hvigor_js_1=require("../../external/core/hvigor.js"),hvigor_system_plugin_js_1=require("../../external/plugin/hvigor-system-plugin.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),file_util_js_1=require("../../util/file-util.js"),time_util_js_1=require("../../util/time-util.js"),global_data_js_1=require("../data/global-data.js"),task_tree_js_1=require("../task/build/task-tree.js"),tasks_js_1=require("../task/build/tasks.js"),task_prune_js_1=require("../task/prune/task-prune.js"),ts_check_js_1=require("../util/ts_check.js"),default_node_impl_js_1=require("./hvigor-node-impl/default-node-impl.js"),_log=hvigor_log_js_1.HvigorLogger.getLogger("configuration");async function configuration(){const e=process_1.default.hrtime(),i=global_data_js_1.globalData.cliEnv,t=hvigor_js_1.hvigor.getProject(),o=path_1.default.resolve(i.cwd,common_const_js_1.HvigorCommonConst.BUILD_FILE_NAME);configNodeTask(t),configProjectTask(t),await evaluateNodeVigorFile(t,(0,file_util_js_1.findRealHvigorFilePath)(o,_log)),await executeAfterNodeEvaluated(t);for(const e of t.getAllSubModules())configNodeTask(e),await evaluateNodeVigorFile(e,(0,file_util_js_1.findRealHvigorFilePath)(e.getBuildFilePath(),_log)),await executeAfterNodeEvaluated(e);if(cluster_1.default.isWorker){const e=process_1.default.hrtime();(0,watch_config_file_js_1.addConfigDeps)();const i=process_1.default.hrtime(e),t=(0,time_util_js_1.formatTime)(i);_log.debug(`hvigorfile, resolve hvigorfile dependencies in ${t}`)}await executeBeforeAllNodesEvaluated(),await executeAfterAllNodesEvaluated();const s=process_1.default.hrtime(e),n=(0,time_util_js_1.formatTime)(s);return _log.debug(`Configuration phase cost:${n}`),t}function configNodeTask(e){e.registry(new tasks_js_1.Tasks(e)),e.registry(new task_tree_js_1.TaskTree(e))}function configProjectTask(e){e.registry(new task_prune_js_1.PruneTask(e))}async function bindSystemPlugins(e,i,t){if(_log.debug("hvigorfile, binding system plugins",e),"function"==typeof e){const t=await e(i);return i.bindPlugin(t),void i.bindPluginContextFunc(t.getPluginId(),t.getContext.bind(t))}if(!(e instanceof hvigor_system_plugin_js_1.HvigorSystemPlugin))if(Object.keys(e).length)for(const o of Object.keys(e)){const s=e[o];if(s instanceof hvigor_system_plugin_js_1.HvigorSystemPlugin)i.bindPlugin(s);else if("function"==typeof s){const e=await s(i);e.getPluginId||_log.errorMessageExit(`Invalid exports, no system plugins were found in hvigorfile: ${t}`),i.bindPlugin(e)}}else _log.debug("hvigorFileExports is empty")}function bindCustomPlugins(e,i,t){if(_log.debug("hvigorfile, binding custom plugins",e),!e||Array.isArray(e)&&0===e.length)return void _log.debug(`hvigorfile, no custom plugins were found in ${t}`);if(!Array.isArray(e))return void _log.warn(`hvigorfile, invalid custom plugins config found in ${t}`);const o=hvigor_js_1.hvigor.getHvigorNodeByScriptPath(t.substring(0,t.lastIndexOf(".")));for(let s=0;s<e.length;s++){const n=e[s];"object"==typeof n&&"string"==typeof n.pluginId&&"function"==typeof n.apply?(n.context&&i.bindPluginContextFunc(n.pluginId,n.context.bind(n)),hvigor_js_1.hvigor.beforeNodesEvaluated((async()=>{_log.debug(`hvigorfile, executing apply function of custom plugin, pluginId=${n.pluginId}`),await n.apply(o)}))):_log.warn(`The plugin 'plugins[${s}]' in the file '${t}' is invalid. This plugin will not be loaded. A valid plugin must contain a 'pluginId' with string type and an 'apply' function`)}}async function evaluateNodeVigorFile(e,i){let t;_log.debug(`hvigorfile, resolving ${i}`),global_data_js_1.startParameters.hvigorfileTypeCheck&&i.endsWith(".ts")&&ts_check_js_1.hvigorfileTSRoots.add(i),delete require.cache[require.resolve(i)];try{t=require(i),_log.debug("hvigorfile, require result: ",t)}catch(e){_log.errorMessageExit(`Resolve ${i} failed. ${e.message}`)}t.default&&t.default.system?(await bindSystemPlugins(t.default.system,e,i),bindCustomPlugins(t.default.plugins,e,i)):await bindSystemPlugins(t,e,i),_log.debug(`hvigorfile, resolve finished ${i}`),cluster_1.default.isWorker&&(0,watch_config_file_js_1.addModuleDependency)(i)}async function executeAfterAllNodesEvaluated(){for(;hvigor_js_1.hvigor.getNodesEvaluatedActionQueue().size()>0;){const e=hvigor_js_1.hvigor.getNodesEvaluatedActionQueue().pop();e&&await e()}}async function executeAfterNodeEvaluated(e){if(e instanceof default_node_impl_js_1.DefaultNodeImpl)for(const i of e.getNodeEvaluatedActions())await i()}async function executeBeforeAllNodesEvaluated(){for(;hvigor_js_1.hvigor.getBeforceAllNodesEvaluatedActions().size()>0;){const e=hvigor_js_1.hvigor.getBeforceAllNodesEvaluatedActions().pop();e&&await e()}}exports.configuration=configuration;