// Script for compiling build behavior. It is built in the build plug-in and cannot be modified currently.
const path = require('path');
const {WorkerPoolFactory} = require('@ohos/hvigor-base/src/internal/pool/worker-pool/worker-pool-factory');
const {WorkerPoolType} = require('@ohos/hvigor-base/src/internal/pool/enum/worker-pool-type');
const {TaskState} = require('@ohos/hvigor-base/src/internal/pool/enum/task-state');

let project = require('@ohos/hvigor')(__filename);
const workPool = WorkerPoolFactory.getWorkerPool(WorkerPoolType.LOCAL, {
  minPoolNum: 3,
  maxPoolNum: 5
});

project.task(function () {
  console.log('This is a test task');
  const tcb = workPool.submit(this, path.resolve(__dirname, 'event.js'), {
    workInput: {
      name: 'test work1'
    }
  });
  if (tcb.getState() === TaskState.REJECT) {
    f('doing test work1...');
  }

}, 'test');

project.task(function () {
  console.log('This is a clean task');

  const tcb1 = workPool.submit(this, path.resolve(__dirname, 'event.js'), {
    workInput: {
      name: 'clean work1'
    }
  });
  if (tcb1.getState() === TaskState.REJECT) {
    f('doing clean work1...');
  }

  const tcb2 = workPool.submit(this, path.resolve(__dirname, 'event.js'), {
    workInput: {
      name: 'clean work2'
    }
  });
  if (tcb2.getState() === TaskState.REJECT) {
    f('doing clean work2...');
  }

  const tcb3 = workPool.submit(this, path.resolve(__dirname, 'event.js'), {
    workInput: {
      name: 'clean work3'
    }
  });
  if (tcb3.getState() === TaskState.REJECT) {
    f('doing clean work3...');
  }

}, 'clean').dependsOn('test');

project.task(function () {
  console.log('This is a clean2 task');

  const tcb = workPool.submit(this, path.resolve(__dirname, 'event.js'), {
    workInput: {
      name: 'clean2 work1'
    }
  });
  if (tcb.getState() === TaskState.REJECT) {
    f('doing clean2 work1...');
  }

}, 'clean2');


project.task(() => {
  console.log('This is a default task');
}, 'default').dependsOn('clean').dependsOn('clean2');

function f(data) {
  console.log(data);
  sleep(1000);
}

function sleep(delay) {
  const start = (new Date()).getTime();
  while ((new Date()).getTime() - start < delay) {
    // 使用  continue 实现；
    continue;
  }
}
