"use strict";
/*
 * Unicode 字符类型的定义，更多详细内容查看
 * [Unicode 标准](https://www.unicode.org/charts/PDF/)
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
// 预留的 unicode 字符范围，一般用于业务范围，不对显示有任何影响，标准组织对此不负责
var rsAstralRange = '\\ud800-\\udfff';
// 语音变化标识符号
var rsComboMarksRange = '\\u0300-\\u036f';
// 组合标识符号（上半、下半、左上、右上、左下、右下等），不是完整的内容
var reComboHalfMarksRange = '\\ufe20-\\ufe2f';
// 组合符号区分标记，不单独成一个字符
var rsComboSymbolsRange = '\\u20d0-\\u20ff';
// 组合符号区分扩展标记，不单独成一个字符，例如上括号、下括号、无穷大∞等
var rsComboMarksExtendedRange = '\\u1ab0-\\u1aff';
// 组合符号区分扩充标记，不单独成一个字符，例如声调等
var rsComboMarksSupplementRange = '\\u1dc0-\\u1dff';
// 组合符号范围全集
var rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange
    + rsComboMarksExtendedRange + rsComboMarksSupplementRange;
// 用于表示各种符号和图形。 它们可以用于文本装饰、标志、箭头、指示器、图形等
var rsDingbatRange = '\\u2700-\\u27bf';
// 常用小写拉丁文字母
var rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff';
// 数学里面的一些操作符号 00ac ¬ 斜划线  00b1 ±  00d7 乘号 00f7 除号
var rsMathOpRange = '\\xac\\xb1\\xd7\\xf7';
/**
 * 控制符号、分割符号、组合区域（括号等）等符号范围
 * 00-1f 是控制符例如 EOL等；
 * 20-2f 是ASCII码的范围，标识空格等分隔符
 * 3a-40 是ascii码的范围，含分隔符类，例如冒号、点号等
 * 5b-60 是ascii码的范围，含中括号、退格符号、下划线等分隔符
 * 7b-7f 是ascii码的范围，含大括号、竖线、波浪号、删除控制符等
 */
var rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf';
/**
 * 含 Space、Format 字符、Dashes、一般标点符号、引号和撇号、不可见操作符等
 */
var rsPunctuationRange = '\\u2000-\\u206f';
/**
 * 分割符号范围
 */
var rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000';
/**
 * 常用大写拉丁文字母
 */
var rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde';
/**
 * 表情符号变量选择
 */
var rsVarRange = '\\ufe0e\\ufe0f';
// 分割切断字符范围
var rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
// 分号和右撇号
var rsApos = "['\u2019]";
// 分割符范围
var rsBreak = "[".concat(rsBreakRange, "]");
// 组合符号全集
var rsCombo = "[".concat(rsComboRange, "]");
var rsDigit = '\\d';
// 符号图形全集
var rsDingbat = "[".concat(rsDingbatRange, "]");
// 小写拉丁字符集
var rsLower = "[".concat(rsLowerRange, "]");
// 标准 Unicode 字符的开始，分割符、数字、字符图、大小写字符
var rsMisc = "[^".concat(rsAstralRange).concat(rsBreakRange + rsDigit + rsDingbatRange + rsLowerRange + rsUpperRange, "]");
// 无意义字符
var rsFitz = '\\ud83c[\\udffb-\\udfff]';
// 查找组合字符或者无意义字符
var rsModifier = "(?:".concat(rsCombo, "|").concat(rsFitz, ")");
// 标准 Unicode 开头的字符
var rsNonAstral = "[^".concat(rsAstralRange, "]");
// 查找表情符号
var rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}';
// 大字节字符范围
var rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]';
// 大写字母范围
var rsUpper = "[".concat(rsUpperRange, "]");
// 零宽度字符之一，它通常用于阿拉伯文与印度语系等文字中，使不会发生连字的字符间产生连字效果。
var rsZWJ = '\\u200d';
var rsMiscLower = "(?:".concat(rsLower, "|").concat(rsMisc, ")");
var rsMiscUpper = "(?:".concat(rsUpper, "|").concat(rsMisc, ")");
// 缩略写法 小写
var rsOptContrLower = "(?:".concat(rsApos, "(?:d|ll|m|re|s|t|ve))?");
// 缩略写法 大写
var rsOptContrUpper = "(?:".concat(rsApos, "(?:D|LL|M|RE|S|T|VE))?");
// 组合或无意义字符
var reOptMod = "".concat(rsModifier, "?");
/**
 * 表情符号开始字符
 */
var rsOptVar = "[".concat(rsVarRange, "]?");
var rsOptJoin = "(?:".concat(rsZWJ, "(?:").concat([rsNonAstral, rsRegional, rsSurrPair].join('|'), ")").concat(rsOptVar + reOptMod, ")*");
/**
 * 小写序, 1st 等
 */
var rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])';
/**
 * 大写序, 1ST 等
 */
var rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])';
var rsSeq = rsOptVar + reOptMod + rsOptJoin;
var rsEmoji = "(?:".concat([rsDingbat, rsRegional, rsSurrPair].join('|'), ")").concat(rsSeq);
var reUnicodeWords = RegExp([
    "".concat(rsUpper, "?").concat(rsLower, "+").concat(rsOptContrLower, "(?=").concat([rsBreak, rsUpper, '$'].join('|'), ")"),
    "".concat(rsMiscUpper, "+").concat(rsOptContrUpper, "(?=").concat([rsBreak, rsUpper + rsMiscLower, '$'].join('|'), ")"),
    "".concat(rsUpper, "?").concat(rsMiscLower, "+").concat(rsOptContrLower),
    "".concat(rsUpper, "+").concat(rsOptContrUpper),
    rsOrdUpper,
    rsOrdLower,
    "".concat(rsDigit, "+"),
    rsEmoji,
].join('|'), 'g');
/**
 * 将 Unicode 字符串拆分成单词数组。
 *
 * @private
 * @param str {string} 待被拆分的字符串
 * @returns {Array} 单词列表数组
 */
function unicodeWords(str) {
    return str.match(reUnicodeWords);
}
exports.default = unicodeWords;
