"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var placeholder = Symbol('placeholder'); // 占位符
// 找到下一个可以存放新arg的位置，从start开始找
function getNextValidPosition(currArgs, start) {
    var index = currArgs.slice(start).indexOf(placeholder);
    return index === -1 ? currArgs.length : index + start;
}
/**
 * 对指定函数进行柯理化
 * @param fn，要柯理化的函数
 * @param _enoughArgsNum，在调用fn之前至少需要收集到的入参的个数
 * @return curriedFn，fn进行柯理化后的函数
 */
function curry(fn, _enoughArgsNum) {
    var enoughArgsNum = Number(_enoughArgsNum || fn.length);
    enoughArgsNum = Number.isNaN(enoughArgsNum) ? 0 : Math.floor(enoughArgsNum);
    var currArgs = []; // 保存当前收集到的所有入参，包括占位符
    var nextValidPosition; // currArgs中下一个可以放入新入参的位置下标
    function restCurry() {
        var addedArgs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            addedArgs[_i] = arguments[_i];
        }
        nextValidPosition = -1;
        addedArgs.forEach(function (newArg) {
            nextValidPosition = getNextValidPosition(currArgs, nextValidPosition + 1);
            currArgs[nextValidPosition] = newArg;
        });
        if (currArgs.filter(function (a) { return a !== placeholder; }).length >= enoughArgsNum) {
            return fn.call.apply(fn, __spreadArray([this], __read(currArgs), false));
        }
        return restCurry;
    }
    function firstCurry() {
        var addedArgs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            addedArgs[_i] = arguments[_i];
        }
        currArgs = []; // 第一次执行柯理化函数，清空之前收集到的入参
        if (this) {
            Object.setPrototypeOf(this, fn.prototype); // new curried()创建的对象的原型必须指向原函数fn
        }
        return restCurry.call.apply(restCurry, __spreadArray([this], __read(addedArgs), false));
    }
    firstCurry.placeholder = placeholder;
    return firstCurry;
}
exports.default = curry;
