"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseCompare_1 = require("./common/baseCompare");
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var identity_1 = __importDefault(require("./identity"));
/**
 * 遍历 collection（集合）元素，返回 predicate（断言函数）返回真值 的所有元素的数组。 predicate（断言函数）调用三个参数：(value, index|key, collection)。
 * 注意: 与 remove 函数不同, 这个函数返回一个新的数组。
 * @since 1.0.0
 * @Catalog Collection
 * @param collection (Array|Object): 一个用来迭代的集合
 * @param [predicate = identity] (Array|Function|Object|string): 每次迭代调用的函数。
 * @returns (Array): 返回一个新的过滤后的数组。
 * @example
 * var users = [
 *   { 'user': 'barney', 'age': 36, 'active': true },
 *   { 'user': 'fred',   'age': 40, 'active': false }
 * ];
 *
 * _.filter(users, function(o) { return !o.active; });
 * // => objects for ['fred']
 *
 * // The `_.matches` iteratee shorthand.
 * _.filter(users, { 'age': 36, 'active': true });
 * // => objects for ['barney']
 *
 * // The `_.matchesProperty` iteratee shorthand.
 * _.filter(users, ['active', false]);
 * // => objects for ['fred']
 *
 * // The `_.property` iteratee shorthand.
 * _.filter(users, 'active');
 * // => objects for ['barney']
 */
function filter(collection, predicate) {
    if (predicate === void 0) { predicate = identity_1.default; }
    var target = Object(collection);
    var isArrayFlag = (0, isArrayLike_1.default)(target);
    var result = [];
    var filterIteratee = (0, baseCompare_1.wrapIteratee)(predicate);
    if (!isArrayFlag) {
        var keys = Object.keys(target);
        for (var i = 0; i < keys.length; i++) {
            var key = keys[i];
            var item = target[key];
            if (filterIteratee(item, i, target)) {
                result.push(item);
            }
        }
    }
    else {
        for (var i = 0; i < target.length; i++) {
            var item = target[i];
            if (filterIteratee(item, i, target)) {
                result.push(item);
            }
        }
    }
    return result;
}
exports.default = filter;
