"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var baseCompare_1 = require("./common/baseCompare");
function findIndexCore(collection, predicate, fromIndex, direction) {
    if (fromIndex === void 0) { fromIndex = 0; }
    if (direction === void 0) { direction = baseCompare_1.ArrayDirection.LEFT; }
    if (direction === baseCompare_1.ArrayDirection.LEFT) {
        for (var i = fromIndex; i < collection.length; i++) {
            if (predicate(collection[i], i, collection)) {
                return i;
            }
        }
    }
    return -1;
}
/**
 * 该方法类似_.find，区别是该方法返回第一个通过 predicate 判断为真值的元素的索引值（index），而不是元素本身。
 * @param Array (Array): 要搜索的数组。
 * @param predicate (Array|Function|Object|string): 这个函数会在每一次迭代调用。
 * @param fromIndex The index to search from.
 * @returns (number): 返回找到元素的 索引值（index），否则返回 -1。
 */
function findIndex(array, predicate, fromIndex) {
    if ((0, baseCompare_1.checkArrayLenValid)(array)) {
        return -1;
    }
    var startIndex = (0, baseCompare_1.getValidIndex)(fromIndex, 0);
    return findIndexCore(array, (0, baseCompare_1.wrapIteratee)(predicate), startIndex >= 0 ? startIndex : Math.max(startIndex + array.length, 0));
}
exports.default = findIndex;
