"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var values_1 = __importDefault(require("./values"));
var toNumber_1 = __importDefault(require("./toNumber"));
var isString_1 = __importDefault(require("./isString"));
var indexOf_1 = __importDefault(require("./indexOf"));
/**
 * 检查 value(值) 是否在 collection(集合) 中
 * 如果 collection(集合)是一个字符串，那么检查 value（值，子字符串） 是否在字符串中
 * 如果找到 value 返回 true， 否则返回 false
 * @param input (Array|Object|string): 要检索的集合
 * @param value 要检索的值
 * @param start 要检索的索引位置(如果指定 fromIndex 是负数，那么从 collection(集合) 的结尾开始检索)
 */
function includes(input, value, start) {
    if (start === void 0) { start = 0; }
    if (value === null || value === undefined) {
        return false;
    }
    var collection = (0, isArrayLike_1.default)(input) ? input : (0, values_1.default)(input);
    var startIndex = start ? (0, toNumber_1.default)(start) : 0;
    if (startIndex < 0) {
        startIndex = Math.max(collection.length + startIndex, 0);
    }
    if ((0, isString_1.default)(collection)) {
        return startIndex <= collection.length && collection.indexOf(value, startIndex) > -1;
    }
    return collection.length && (0, indexOf_1.default)(collection, value, startIndex) > -1;
}
exports.default = includes;
