"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var isEmpty_1 = __importDefault(require("./isEmpty"));
var sameValueZero_1 = __importDefault(require("./common/sameValueZero"));
/**
 * 移除数组array中所有和数组中的值相同的元素，使用SameValueZero 进行全等比较。
 * Note: 这个方法不同于 difference ，他会改变 array
 * @since 1.0.0
 * @param array (Array): 要修改的数组。
 * @param values (Array): 要移除值的数组。
 * @returns (Array): 返回 array。
 * @example
 * var array = [1, 2, 3, 1, 2, 3];
 *
 * _.pullAll(array, [2, 3]);
 * console.log(array);
 * // => [1, 1]
 */
function pullAll(array, values) {
    if ((0, isNil_1.default)(array) || (0, isNil_1.default)(values) || (0, isEmpty_1.default)(array) || (0, isEmpty_1.default)(values)) {
        return array;
    }
    var len = array.length;
    var _loop_1 = function () {
        var item = array[len];
        var findIdx = values.findIndex(function (v) {
            return (0, sameValueZero_1.default)(item, v);
        });
        if (findIdx !== -1) {
            array.splice(len, 1);
        }
    };
    while (--len >= 0) {
        _loop_1();
    }
    return array;
}
exports.default = pullAll;
