"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
/**
 * 根据指定属性获得source对象（数组）中的值，并剔除属性
 * @param source，要取的值的对象（数组）
 * @param indexes，index数组。index不一定为数组下标，此时强转为string类型作为属性
 * @return result，根据指定属性所获得的值组成的数组
 */
function pullAt(source) {
    var e_1, _a;
    var indexes = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        indexes[_i - 1] = arguments[_i];
    }
    if (!source) {
        return [];
    }
    var paths = []; // 保存函数入参接收到的所有路径
    try {
        for (var indexes_1 = __values(indexes), indexes_1_1 = indexes_1.next(); !indexes_1_1.done; indexes_1_1 = indexes_1.next()) {
            var ele = indexes_1_1.value;
            if (Array.isArray(ele)) {
                paths = paths.concat(ele.map(function (e) { return (0, utils_1.toStringWithZeroSign)(e); })); // 如果e=-0需要得到'-0'
            }
            else {
                paths.push((0, utils_1.toStringWithZeroSign)(ele));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (indexes_1_1 && !indexes_1_1.done && (_a = indexes_1.return)) _a.call(indexes_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (paths.length === 0) { // 如果入参没有提供任何path，直接返回空数组
        return [];
    }
    var result = [];
    // 保存path指向的对象或者值
    var pathToValueMap = new Map();
    // 根据path拿到source中的值，并剔除path属性
    paths.forEach(function (path) {
        var pathValue;
        if (pathToValueMap.has(path)) {
            pathValue = pathToValueMap.get(path);
        }
        else {
            var _a = getPenultimateValueByPath(source, path), penultimateValue = _a.penultimateValue, lastKey = _a.lastKey;
            pathValue = penultimateValue[lastKey];
            delete penultimateValue[lastKey];
        }
        result.push(pathValue);
        if (!pathToValueMap.has(path)) {
            pathToValueMap.set(path, pathValue);
        }
    });
    // 如果source是数组且path是合法下标，还需要让剔除后空出的位置由后方数组元素补齐
    if (Array.isArray(source)) {
        var newArr = []; // 将source数组中未被剔除的元素存进newArr
        for (var i = 0; i < source.length; i++) {
            if (Object.prototype.hasOwnProperty.call(source, String(i))) {
                newArr.push(source[i]);
            }
        }
        newArr.forEach(function (ele, index) { source[index] = ele; });
        source.length = newArr.length;
    }
    return result;
}
/*
 * 根据（深层）path，将其作为key，取到其指向的对象的上层对象。
 * 例如 obj={a:{b:{}}}, path='a.b',返回{ penultimateValue: obj.a, lastKey:'b'}
 */
function getPenultimateValueByPath(obj, path) {
    var e_2, _a;
    if (Object.prototype.hasOwnProperty.call(obj, path)) {
        return { penultimateValue: obj, lastKey: path };
    }
    var keys = path.split('.');
    var lastKey = keys.pop(); // path中最后一个有效的key
    var pointer = obj; // 指针
    try {
        for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
            var key = keys_1_1.value;
            var nextValue = pointer[key];
            if (nextValue === undefined || nextValue === null) { // undefined[key]或者null[key]会报错，故跳出循环
                lastKey = key;
                break;
            }
            pointer = nextValue;
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return { penultimateValue: pointer, lastKey: lastKey };
}
exports.default = pullAt;
