"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isString_1 = __importDefault(require("./isString"));
var isSymbol_1 = __importDefault(require("./isSymbol"));
/**
 * 转换 input 为字符串。 null 和 undefined 将返回空字符串。-0 将被转换为字符串"-0"。
 * @param input
 */
function toString(input) {
    if (input === null || input === undefined) {
        return '';
    }
    if ((0, isString_1.default)(input)) {
        return input;
    }
    if (Array.isArray(input)) {
        return "".concat(input.map(function (item) { return (item === null || item === undefined ? item : toString(item)); }));
    }
    if ((0, isSymbol_1.default)(input)) {
        return input.toString();
    }
    if ("".concat(input) === '0' && (1 / input) === (1 / -0)) {
        return '-0';
    }
    return "".concat(input);
}
exports.default = toString;
