"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var unicodeWord_1 = __importDefault(require("./common/unicodeWord"));
/**
 * 将指定字符串拆分成单词数组。
 *
 * @since 1.0.0
 * @param {string} [str=''] 待转换的字符串
 * @param {RegExp|string} [pattern] 匹配规则
 * @returns {Array} 单词数组。
 * @example
 *
 * words('fred, barney, & pebbles')
 * // => ['fred', 'barney', 'pebbles']
 *
 * words('fred, barney, & pebbles', /[^, ]+/g)
 * // => ['fred', 'barney', '&', 'pebbles']
 */
function words(str, pattern) {
    if (str === void 0) { str = ''; }
    if (pattern === void 0) { pattern = undefined; }
    if (pattern === undefined) {
        var result = (0, unicodeWord_1.default)(str);
        return result || [];
    }
    return str.match(pattern) || [];
}
exports.default = words;
