declare const FileCoverage: any;
interface baseType {
    line: number | undefined;
    column: number | undefined;
}
export interface locType {
    start: baseType;
    end: baseType;
    filename?: string | undefined;
    identifierName?: string | undefined;
}
interface metaType {
    final: {
        s: number;
        f: number;
        b: number;
    };
}
/**
 * SourceCoverage provides mutation methods to manipulate the structure of
 * a file coverage object. Used by the instrumenter to create a full coverage
 * object for a file incrementally.
 *
 * @private
 * @param pathOrObj {String|Object} - see the argument for {@link FileCoverage}
 * @extends FileCoverage
 * @constructor
 */
declare class SrcCoverage extends FileCoverage {
    meta: metaType;
    constructor(pathOrObj: string | object);
    newStatement(loc: locType | undefined): number;
    newFunction(name: string | undefined, decl: locType, loc: locType | undefined): number;
    newBranch(type: string, loc: locType | undefined, isReportLogic?: boolean): number;
    maybeBranchTrue(type: string, name: number, isReportLogic: boolean): void;
    addBranchPath(name: string, location: locType): number;
    maybeAddBranchTrue(name: string): void;
    getInputSource(sourceMap: any): void;
    deleteBranch(): void;
}
export { SrcCoverage };
