import type { FileCoverage } from 'istanbul-lib-coverage';
interface Visitor {
    enter(path: string): void;
    exit(path: string): {
        fileCoverage: FileCoverage;
        sourceMappingURL: string;
    };
}
/**
 * programVisitor 是用于instrumentation的“babel”适配器.
 * 它返回一个含有`enter`和`exit`两个方法的对象。
 * 在babel visitor中，这些函数应分配给“程序”进入和退出函数，或从“程序”进入和退出函数调用
 * 这些函数不对Babel设置的状态进行假设，因此可以在Babel插件以外的上下文中使用。
 *
 * exit函数返回一个当前具有以下键的对象：
 * `fileCoverage` -为源文件创建的文件覆盖对象。
 * `sourceMappingURL` -处理文件时找到的任何source mapping URL 。
 *
 * @param {Object} types - an instance of babel-types.
 * @param {string} sourceFilePath - the path to source file.
 * @param {Object} opts - additional options.
 * @param {string} [opts.coverageVariable=__coverage__] the global coverage variable name.
 * @param {boolean} [opts.reportLogic=false] report boolean value of logical expressions.
 * @param {string} [opts.coverageGlobalScope=this] the global coverage variable scope.
 * @param {boolean} [opts.coverageGlobalScopeFunc=true] use an evaluated function to find coverageGlobalScope.
 * @param {Array} [opts.ignoreClassMethods=[]] names of methods to ignore by default on classes.
 * @param {object} [opts.inputSourceMap=undefined] the input source map, that maps the uninstrumented code back to the
 * original code.
 */
export declare const programVisitor: (types: any, sourceFilePath?: string, opts?: any) => Visitor;
export {};
