import { HosSdkVersion } from './hos-component';
/**
 * 获取HarmonyOS Version和OpenHarmony API Version的配套表信息
 */
export declare class HosVersionMapper {
    static INSTANCE: HosVersionMapper;
    /**
     * 获取配套的HarmonyOS Version所对应的API Version
     *
     * @param hosVersion HarmonyOS Version
     * @return 一般情况下baseApi只会有一个，由于3.0.0同时对应api8和api7，因此这里的返回类型改成了List
     */
    getBaseApi(hosVersion: string): number[];
    /**
     * 获取当前IDE所能支持的版本列表
     *
     * @return HosSdkVersion[]
     */
    getSupportVersions(): HosSdkVersion[];
    /**
     * 检查当前的hosVersion是否为支持的版本
     *
     * @param hosVersion HarmonyOS Version，不能传baseApi
     * @return 如果是支持的HarmonyOS Version则返回true，否则返回false
     */
    isSupportVersion(hosVersion: string): boolean;
    /**
     * 根据baseApi查询与之配套的HarmonyOS Version
     *
     * @param baseApi OpenHarmony的API Version
     * @return HarmonyOS Version，如果查不到就返回空字符串
     */
    getHosVersion(baseApi: number): string;
    /**
     * 根据platformVersion查询与之配套的HarmonyOS SDK名称
     *
     * @param platformVersion HarmonyOS的platformVersion
     * @return HarmonyOS 名称，如果查不到就返回空字符串
     */
    getHosSdkName(platformVersion: string): string;
    /**
     * 根据platformVersion查询与之配套的HarmonyOS SDK path
     *
     * @param platformVersion HarmonyOS的platformVersion
     * @return HarmonyOS 名称，如果查不到就返回空字符串
     */
    getHosSdkPath(platformVersion: string): string;
    /**
     * 将version转换成HosSdkVersion对象，如果这个version对应多个HosSdkVersion，那么就取最高的那个HosSdkVersion
     *
     * @param version HarmonyOS Version或者OpenHarmony API Version
     * @return HosSdkVersion，如果在配套表中找不到对应的version就返回null
     */
    transferVersionIntoHosVersion(version: string): HosSdkVersion | undefined;
}
