import { AbstractComponentLoader, CommonNetClient, Component, Progress, SdkSettings } from '@ohos/sdkmanager-common';
import { HosComponentDto } from '../dto/hos-component-dto';
export declare abstract class AbstractHosRemoteComponentLoader extends AbstractComponentLoader {
    protected readonly settings: SdkSettings;
    protected readonly netClient: CommonNetClient;
    protected constructor(settings: SdkSettings, netClient: CommonNetClient, progress: Progress);
    load(): Promise<Component[]>;
    /**
     * http请求参数
     * @protected
     */
    protected abstract createReqParam(): MetaReqDto;
    private _createHeader;
    private _shouldShow;
    /**
     * 将json对象转换为Dto对象
     * @param jsonObject
     * @protected
     */
    protected convertComponent(jsonObject: any): HosComponentDto;
    private _configArchive;
    protected addComponent(result: HosComponentDto[], componentDto: HosComponentDto): void;
}
export interface MetaReqDto {
    osType: string;
    osArch: string;
    supportVersion: string;
    deviceName: string;
}
