import { SourceDescription } from '@ohos/hvigor-arkts-base';
export interface HvigorCompilePlugin extends CompileHookInterface {
    name: string;
    order?: 'last' | 'first' | OrderFunctionType;
}
export interface CompileHookInterface {
    buildStart?: (this: HvigorCompilePluginContext) => void;
    resolveId?: (this: HvigorCompilePluginContext, source: string, importer: string | undefined) => string | NullValue | false;
    load?: (this: HvigorCompilePluginContext, id: string) => SourceDescription | string | NullValue;
    transform?: (this: HvigorCompilePluginContext, code: string, id: string) => SourceDescription | string | NullValue;
    shouldInvalidCache?: (this: HvigorCompilePluginContext, options: ShouldInvalidCacheOptions) => boolean | NullValue;
    moduleParsed?: (this: HvigorCompilePluginContext, moduleInfo: ModuleInfo) => void;
    buildEnd?: (this: HvigorCompilePluginContext, error?: Error) => void;
}
export interface HvigorCompilePluginContext {
    getFileName: (fileReferenceId: string) => string;
    getModuleIds: () => IterableIterator<string>;
    getModuleInfo: (moduleId: string) => ModuleInfo | null;
    parse: (input: string, options?: any) => AcornNode;
    share: any;
}
export interface ModuleInfo {
    id: string;
    code: string | null;
    ast: AcornNode | null;
    originalCode: string | null;
    importedIds: readonly string[];
    importers: readonly string[];
    isEntry: boolean;
    isExternal: boolean;
    isIncluded: boolean | null;
    hasDefaultExport: boolean | null;
    exports: string[] | null;
    dynamicallyImportedIds: readonly string[];
    exportedBindings: Record<string, string[]> | null;
    dynamicImporters: readonly string[];
}
export interface ShouldInvalidCacheOptions {
    ast?: AcornNode;
    code: string;
    id: string;
}
export interface AcornNode {
    end: number;
    start: number;
    type: string;
}
export declare type NullValue = null | undefined | void;
declare type OrderFunctionType = (order: Record<string, number>) => number;
export {};
