import { CommonSdkInfoHandler } from '../../core/api/common-sdk-info-handler';
import { Progress } from '../../core/log/progress';
import { SdkInfoConfig } from '../../core/api/sdk-info-config';
import { SimpleProgress } from '../../core/log/simple-progress';
import { PathAndApiVersion } from '../../core/api/path-and-apiversion';
import { Component } from '../../core/api/component';
import { ErrorTip } from '../../core/api/error-tip';
import { License } from '../../core/license/license-manager';
import { ComponentTask } from '../../core/task/component-task';
export declare const getArkUIXMenuLocation: () => "DevEco Studio > Preferences > ArkUI-X" | "File > Settings > ArkUI-X";
export declare class ArkUIXSdkInfoHandler extends CommonSdkInfoHandler {
    private readonly _progress;
    private readonly _sdkInfoConfig;
    constructor(sdkInfoConfig: SdkInfoConfig, progress?: SimpleProgress);
    getOrDownload(pathAndApiVersions: PathAndApiVersion[]): Promise<Map<PathAndApiVersion, Component>>;
    protected getLocalComponents(): Component[];
    protected getRemoteComponents(): Promise<Component[]>;
    protected getProgress(): Progress;
    protected findUnacceptedLicenses(components: Component[]): Promise<License[] | undefined>;
    protected getLicenseNotAcceptedMessage(fullNameList: string[]): ErrorTip;
    protected createInstallComponentTask(component: Component): ComponentTask;
    protected getNotFoundException(): string;
}
