"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQueryMetaUrl = exports.getQueryLicenseUrl = void 0;
const utils_1 = require("../../core/util/utils");
const url_contants_1 = require("../../core/constants/url-contants");
const SERVICE_NAME = 'com.huawei.devecostudio.global';
const KEY_SDK = 'ohsdk';
function getQueryLicenseUrl(grsService) {
    return `${getServerAddress(grsService)}/sdkmanager/crossPlatform/licenses`;
}
exports.getQueryLicenseUrl = getQueryLicenseUrl;
function getQueryMetaUrl(grsService) {
    return `${getServerAddress(grsService)}/sdkmanager/crossPlatform/getSdkList`;
}
exports.getQueryMetaUrl = getQueryMetaUrl;
function getServerAddress(grsService) {
    const domain = grsService.getUrl(SERVICE_NAME, KEY_SDK);
    if ((0, utils_1.isEmpty)(domain)) {
        return url_contants_1.urls.harmonyOSRepo;
    }
    return domain;
}
