"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultGrsUrls = exports.ComponentPath = exports.VERSION_2_0_0 = exports.META_VERSION_PATTERN = exports.VERSION_PATTERN = void 0;
const url_contants_1 = require("./url-contants");
/**
 * version正则表达式
 */
exports.VERSION_PATTERN = /^(\d+)(\.\d+){3}$/;
/**
 * metaVersion字段的正则表达式
 */
exports.META_VERSION_PATTERN = /^(\d+)(\.\d+){2}$/;
/**
 * sdk元数据中没有meta字段时，默认的meta里面的metaVersion值
 */
exports.VERSION_2_0_0 = '2.0.0';
/**
 * sdk的path属性枚举
 */
var ComponentPath;
(function (ComponentPath) {
    ComponentPath["JAVA"] = "java";
    ComponentPath["JS"] = "js";
    ComponentPath["NATIVE"] = "native";
    ComponentPath["PREVIEWER"] = "previewer";
    ComponentPath["TOOLCHAINS"] = "toolchains";
    ComponentPath["EMULATOR"] = "emulator";
    ComponentPath["ETS"] = "ets";
    ComponentPath["COMMAND_LINE_TOOLS"] = "command-line-tools";
    ComponentPath["ARKUI_X"] = "arkui-x";
})(ComponentPath = exports.ComponentPath || (exports.ComponentPath = {}));
/**
 * grs兜底url
 */
exports.defaultGrsUrls = url_contants_1.urls.grs;
