import { SdkProxyInfo } from '../api/sdk-proxy-info';
import { Progress } from '../log/progress';
export declare class CommonNetClient {
    private _axiosInstance;
    constructor(proxyInfo?: SdkProxyInfo);
    /**
     * post请求
     *
     * @param url url地址
     * @param progress 进度条
     * @param param 请求参数信息
     * @param header 请求头信息
     * @return result 可以指定返回的数据类型,
     * 需要注意的是如果需要对结果进行JSON.parse的话，需要先进行JSON.stringify，否则会报错
     * 如果请求失败返回undefined
     */
    doPost<T>(url: string, progress: Progress, param?: any, header?: Record<string, string>): Promise<T | undefined>;
    /**
     * get请求下载操作
     *
     * @param url 下载地址
     * @param downloadLocation 下载到本地的文件路径
     * @param progress 进度条
     * @throws SdkException 如果下载时存储文件的操作失败了就抛这个异常
     * @return 下载成功返回true，如果是网络请求失败了就返回false
     */
    doGetDownload(url: string, downloadLocation: string, progress: Progress): Promise<boolean>;
    /**
     * post请求下载操作
     *
     * @param url 下载地址
     * @param downloadLocation 下载到本地的文件路径
     * @param progress 进度条
     * @param param 请求参数
     * @param header 请求头
     * @throws SdkException 如果下载时存储文件的操作失败了就抛这个异常
     * @return 下载成功返回true，如果是网络请求失败了就返回false
     */
    doPostDownload(url: string, downloadLocation: string, progress: Progress, param?: any, header?: Record<string, string>): Promise<boolean>;
    private saveToFile;
    /**
     * get请求
     *
     * @param url 请求地址
     * @param progress 进度条
     * @return result 可以指定返回的数据类型
     * 需要注意的是如果需要对结果进行JSON.parse的话，需要先进行JSON.stringify，否则会报错
     * 如果请求失败返回undefined
     */
    doGet<T>(url: string, progress: Progress): Promise<T | undefined>;
}
