import { Component } from '../api/component';
import { SdkSettings } from '../domain/sdk-settings';
import { Progress } from '../log/progress';
import { AbstractComponentTask } from './abstract-component-task';
import { InstallTask } from './install-task';
import { CommonNetClient } from '../net/common-net-client';
export declare abstract class AbstractInstallTask extends AbstractComponentTask implements InstallTask {
    protected readonly sdkSettings: SdkSettings;
    protected readonly netClient: CommonNetClient;
    protected constructor(component: Component, sdkSettings: SdkSettings, netClient: CommonNetClient);
    getSdkSettings(): SdkSettings;
    getComponent(): Component;
    getSdkRoot(): string;
    prepare(progress: Progress): Promise<void>;
    complete(progress: Progress): Promise<void>;
    abstract download(progress: Progress): Promise<string>;
    protected downloadHelper(downloadUrl: string, downloadLocation: string, progress: Progress): Promise<void>;
    /**
     * 清除残留文件
     * @param filePath
     */
    private _cleanLegacyFile;
    protected getFileNameFromUrl(url: string): string;
    private _verifyComponent;
    private _unzip;
    private _moveToTarget;
    getWorkDir(): string;
    private _getTempInstallLocation;
    getTempComponentPath(): string;
    protected abstract getUniPackageName(): string;
}
