import { Progress } from '../log/progress';
import { Component } from '../api/component';
export interface ComponentTask {
    /**
     * execute
     * @param progress
     */
    execute(progress: Progress): Promise<void>;
    /**
     * Component
     */
    getComponent(): Component;
    /**
     * 获取工作目录
     */
    getWorkDir(): string;
    /**
     * 获取workDir的根路径
     */
    getRootWorkDir(): string;
    /**
     * 获取SDK根路径
     */
    getSdkRoot(): string;
    /**
     * 准备阶段，操作失败不会对原有的SDK产生影响
     * @param progress
     * @protected
     */
    prepare(progress: Progress): Promise<void>;
    /**
     * 最终处理阶段，操作失败会对现有的SDK产生影响
     * @param progress
     * @protected
     */
    complete(progress: Progress): Promise<void>;
}
