import { CommonSdkInfoHandler } from '../../core/api/common-sdk-info-handler';
import { Component } from '../../core/api/component';
import { SdkInfoConfig } from '../../core/api/sdk-info-config';
import { Progress } from '../../core/log/progress';
import { SimpleProgress } from '../../core/log/simple-progress';
import { License } from '../../core/license/license-manager';
import { ErrorTip } from '../../core/api/error-tip';
import { ComponentTask } from '../../core/task/component-task';
import { PathAndApiVersion } from '../../core/api/path-and-apiversion';
export declare class OhSdkInfoHandler extends CommonSdkInfoHandler {
    private readonly _progress;
    private readonly _sdkInfoConfig;
    constructor(sdkInfoConfig: SdkInfoConfig, progress?: SimpleProgress);
    getOrDownload(pathAndApiVersions: PathAndApiVersion[]): Promise<Map<PathAndApiVersion, Component>>;
    protected getLocalComponents(): Component[];
    protected getProgress(): Progress;
    protected getRemoteComponents(): Promise<Component[]>;
    protected findUnacceptedLicenses(components: Component[]): Promise<License[] | undefined>;
    protected getLicenseNotAcceptedMessage(fullNameList: string[]): ErrorTip;
    protected createInstallComponentTask(component: Component): ComponentTask;
    private _getLocalIncompatibleSdks;
}
