"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OhSdkInfoHandler = void 0;
const common_sdk_info_handler_1 = require("../../core/api/common-sdk-info-handler");
const sdk_info_settings_1 = require("../../core/domain/sdk-info-settings");
const simple_progress_1 = require("../../core/log/simple-progress");
const oh_remote_component_loader_1 = require("../loader/oh-remote-component-loader");
const oh_license_manager_1 = require("../license/oh-license-manager");
const error_tip_1 = require("../../core/api/error-tip");
const ohos_task_factory_1 = require("../task/ohos-task-factory");
const oh_local_component_loader_1 = require("../loader/oh-local-component-loader");
const sdk_exception_1 = require("../../core/api/sdk-exception");
class OhSdkInfoHandler extends common_sdk_info_handler_1.CommonSdkInfoHandler {
    constructor(sdkInfoConfig, progress = new simple_progress_1.SimpleProgress()) {
        super(new sdk_info_settings_1.SdkInfoSettings(sdkInfoConfig));
        this._progress = progress;
        this._sdkInfoConfig = sdkInfoConfig;
    }
    getOrDownload(pathAndApiVersions) {
        const loader = new oh_local_component_loader_1.OhLocalComponentLoader(this.sdkSettings.getLocation(), this._progress);
        return this.doGetOrDownload(pathAndApiVersions, this.mapComponents(loader.load()), component => {
            const inCompatibleComponents = loader.getInCompatibleComponents();
            if (inCompatibleComponents.length > 0) {
                throw new sdk_exception_1.SdkException('', new error_tip_1.ErrorTip('', 'The SDK management mode has changed.', `
\t\tMethod 1: Update the SDKs by going to Tools > SDK Manager > SDK > OpenHarmony and following the onscreen instructions. Open SDK Manager
\t\tMethod 2: Uninstall the SDKs in the following paths:
${inCompatibleComponents.map(component => `\t\t    ${component.getLocation()}`).join('\n')}\n`));
            }
        });
    }
    getLocalComponents() {
        return new oh_local_component_loader_1.OhLocalComponentLoader(this.sdkSettings.getLocation(), this._progress).load();
    }
    getProgress() {
        return this._progress;
    }
    getRemoteComponents() {
        return new oh_remote_component_loader_1.OhRemoteComponentLoader(this.sdkSettings, this.sdkSettings.getNetClient(), this._progress).load();
    }
    findUnacceptedLicenses(components) {
        const licenseIds = components.map(component => component.getLicense());
        return new oh_license_manager_1.OhLicenseManager(this.sdkSettings, this.sdkSettings.getNetClient()).findUnacceptedLicenses(licenseIds, this._progress);
    }
    getLicenseNotAcceptedMessage(fullNameList) {
        const sdkInfo = fullNameList.join(',');
        return new error_tip_1.ErrorTip('', 'The SDK license agreement is not accepted.', `Go to Tools > SDK Manager > SDK > OpenHarmony, download the ${sdkInfo} SDK, and accept the license agreement. Open SDK Manager`);
    }
    createInstallComponentTask(component) {
        return (0, ohos_task_factory_1.createOhInstallTask)(component, this.sdkSettings, this.sdkSettings.getNetClient());
    }
    _getLocalIncompatibleSdks(loader) {
        return loader.getInCompatibleComponents().map(component => component.getPath());
    }
}
exports.OhSdkInfoHandler = OhSdkInfoHandler;
