"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OhLicenseManager = void 0;
const license_manager_1 = require("../../core/license/license-manager");
const error_tip_1 = require("../../core/api/error-tip");
const oh_biz_util_1 = require("../util/oh-biz-util");
const utils_1 = require("../../core/util/utils");
class OhLicenseManager extends license_manager_1.AbstractLicenseManager {
    constructor(sdkSettings, netClient) {
        super();
        this._sdkSettings = sdkSettings;
        this._netClient = netClient;
    }
    getLicensesRootLocation() {
        return this._sdkSettings.getLocation();
    }
    getReadLocalHashErrorMessage(licensesLocation) {
        return new error_tip_1.ErrorTip('Failed to read the license file.', 'The license file may be corrupted or missing.', `Delete the ${licensesLocation} folder and \
      go to Tools > SDK Manager > SDK > OpenHarmony to download any SDK. Open SDK Manager`).getMessage();
    }
    retrieveLicenses(licenseIds, progress) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const grsService = yield this._sdkSettings.getGrsService();
                const queryLicenseUrl = (0, oh_biz_util_1.getQueryLicenseUrl)(grsService);
                const data = yield this._netClient.doPost(queryLicenseUrl, progress, this._createReqBody(licenseIds));
                const resultMap = new Map();
                if (data) {
                    for (const ohLicenseRspDto of data) {
                        const licenseContent = yield this._netClient.doGet(ohLicenseRspDto.url, progress);
                        if (!(0, utils_1.isEmpty)(licenseContent)) {
                            const license = {
                                id: ohLicenseRspDto.licenseId,
                                content: licenseContent,
                            };
                            resultMap.set(ohLicenseRspDto.licenseId, license);
                        }
                    }
                }
                return resultMap;
            }
            catch (e) {
                progress.warn(`Failed to request OpenHarmony SDK license, ${e}`);
            }
            return new Map();
        });
    }
    _createReqBody(licenseIds) {
        return {
            licenseIds: licenseIds,
        };
    }
}
exports.OhLicenseManager = OhLicenseManager;
