"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OhSingleTaskWrapper = void 0;
const single_task_wrapper_1 = require("../../core/task/single-task-wrapper");
const error_tip_1 = require("../../core/api/error-tip");
class OhSingleTaskWrapper extends single_task_wrapper_1.SingleTaskWrapper {
    constructor(componentTask) {
        super(componentTask);
    }
    getDuplicateTaskErrorTip(lockFile) {
        return new error_tip_1.ErrorTip('', `Failed to download the ${this.getComponent().getFullName()} SDK because the LOCK file ${lockFile} could not be obtained.`, `
\t\t1. Wait until no other service (preview or sync) is processing the SDK and then try again.
\t\t2. If no other service (preview or sync) is processing the SDK, you can manually delete the LOCK file and then try again. You can also download the SDK under Tools > SDK Manager > SDK > OpenHarmony. Open SDK Manager
\t\t3. If the LOCK file does not exist, the SDK is not being processed. In this case, check the SDK status and manage the SDK under Tools > SDK Manager > SDK > OpenHarmony. Open SDK Manager`);
    }
}
exports.OhSingleTaskWrapper = OhSingleTaskWrapper;
