import { AbstractProjectPlugin } from '../../common/abstract-project-plugin.js';
import { OhosProjectContext, Product } from '../plugin-context.js';
import { ProjectTaskService } from '../../../tasks/service/project-task-service.js';
/**
 * Project级别的上下文信息
 */
export declare class OhosProjectContextImpl implements OhosProjectContext {
    private readonly projectPlugin;
    private currentProduct;
    private projectPath;
    private buildProductOutputPath;
    private buildRootPath;
    private taskService;
    constructor(projectPlugin: AbstractProjectPlugin, taskService: ProjectTaskService);
    getProjectName(): string;
    getBuildMode(): string;
    getProjectPath(): string;
    getCurrentProduct(): Product;
    initCurrentProduct(): void;
    initBuildPath(): void;
    getBuildProductOutputPath(): string;
    getBuildRootPath(): string;
}
