import { FileSet, TaskDetails, TaskInputValue } from '@ohos/hvigor';
import { JsonProfile } from '../../model/json-profile.js';
import { TargetTaskService } from '../service/target-task-service.js';
import { OhosHapTask } from '../task/ohos-hap-task.js';
/**
 * preBuild Task
 *
 * @since 2022/1/10
 */
export declare abstract class AbstractPreBuild extends OhosHapTask {
    private _log;
    private readonly entryCardPath;
    protected readonly apiType: string;
    protected readonly targetStatusCode: number;
    protected readonly syscapJsonPath: string;
    protected readonly containsEts: boolean;
    protected readonly deviceTypes: string[];
    protected readonly dependencies: Record<string, string>;
    protected readonly compilePluginFile: string | undefined;
    protected readonly dynamicDependencies: Record<string, string>;
    protected readonly jsonProfile: JsonProfile;
    protected readonly fromConfigFilePathArr: string[];
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    beforeAlwaysAction(): Promise<void>;
    protected constructor(taskService: TargetTaskService, taskName: TaskDetails);
    initTaskDepends(): void;
    protected doTaskAction(): Promise<void>;
    /**
     * 校验用户配置的compilePluginFile是否符合规范
     *
     * @private
     */
    private checkHvigorPluginFile;
    /**
     * 校验文件路径后缀是否是.ts（如果后缀存在）
     *
     * @param hvigorPluginFile 待校验的路径
     * @private
     */
    private checkSuffix;
    protected isPackingTestPackage(): boolean;
    protected abstract doValidateForDiffApiType(): void;
    protected abstract getJsonProfileByModel(): JsonProfile;
    protected supportOHPM(): any;
    protected doSyscapPreCheck(): void;
    /**
     * 校验hsp/har ohPackage.json5中的main字段和types字段配置的文件是否存在
     */
    checkPackageJson5Config(): Promise<void>;
    private checkWorkerConfig;
    protected versionCheck(): void;
    /**
     * 校验编译语言是否支持wearable,只有API8的非js工程进行拦截
     * @private
     */
    private checkCodeTypeForWearable;
    /**
     * 校验编译语言是否支持瘦设备lite-wearable、smartVision,对API8及API8以上的非js工程进行拦截
     * @private
     */
    private checkCodeTypeForLiteWearable;
    /**
     * 校验SDK版本是否支持ohpm工程
     * @private
     */
    private checkOhpmProjectSdkVersion;
    /**
     * 校验API版本是否支持测试框架
     * @private
     */
    private checkApiVersionForUnitTest;
    protected validateModuleName(profileModuleName: string, moduleName: string, sourceConfigName: string): void;
    protected getBundleType(): string;
    protected isAtomicServiceProject(): boolean;
    private checkArkTSCompatibility;
    private checkCustomTypesSupport;
    private checkCustomTypesIsValid;
    private checkCustomTypePathIsValid;
    /**
     * 解析模块级/工程级的oh-package.json5/package.json获取其dependencies或devDependencies
     * @param model CoreModuleModelImpl | ProjectModel
     * @private
     */
    private getDependencies;
    /**
     * 校验dynamicImport配置中文件配置
     * 仅检查包名是否为本模块oh-package.json5中dependencies的子集;相对路径通过schema校验,且同时检查文件是否存在
     * @private
     */
    private checkDynamicImportFile;
    private checkCustomTypeExtName;
    private getCustomTypePathExist;
    private getModuleDynamicDependencies;
    private checkDynamicDependenciesSupport;
    private checkDimension;
    /**
     * entryModules字段在stage模型工程中标识废弃 编辑器中无法通过schema体现 则在构建时抛出warning
     * @private
     */
    private checkEntryModules;
    private getFromConfigFilePathArr;
    private checkWidget;
    private checkRequestPermissions;
    private findDuplicatedPermissions;
    protected isValidWidget(isArkTsWidget: boolean, parentDir: string, formPath: string): boolean;
    private visualExists;
}
