import { FileSet, TaskInputValue } from '@ohos/hvigor';
import { JsonProfile } from '../model/json-profile.js';
import { AbstractPreBuild } from './abstract/abstract-pre-build.js';
import { TargetTaskService } from './service/target-task-service.js';
/**
 * preBuild Task
 *
 * @since 2022/1/10
 */
export declare class PreBuild extends AbstractPreBuild {
    private readonly appJson5Path;
    private readonly projectProfilePath;
    private readonly insightIntentJsonPath;
    private readonly targetJsonPath;
    private readonly targetModuleOptObj;
    private readonly resourcePath;
    private readonly pagesJsonPath;
    private readonly formJsonPathArr;
    private readonly profilePath;
    protected isPreview: boolean | undefined;
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    constructor(taskService: TargetTaskService);
    protected doValidateForDiffApiType(): void;
    /**
     * DTS2024010407744临时规避方案，当存在.preview缓存时移动mock-config.json5配置文件，需要删除.preview中mock-config缓存文件
     * @protected
     */
    protected mockCacheClean(): void;
    /**
     * 对compileSdkVersion和compatibleSdkVersion进行校验，对runtimeOS进行校验
     *
     * @protected
     */
    protected buildProfileJsonValidate(): void;
    /**
     * insight_intent.json文件校验
     *
     * @protected
     */
    protected insightIntentJsonValidate(): void;
    protected appJson5Validate(): void;
    protected moduleJson5Validate(): void;
    private formJsonValidate;
    beforeAlwaysAction(): Promise<void>;
    private checkEntryModuleJson;
    /**
     * hap: src/main/resources/base/profile/main_pages.json
     * hsp: src/main/resources/base/profile/main_pages.json
     * har: undefined
     * ohosTest: src/ohosTest/resources/base/profile/test_pages.json
     *
     * @private
     */
    private getPagesJsonPath;
    private pagesJsonValidate;
    /**
     * 1. validate form file is under current module
     * 2. validate form file exists
     *
     * @param formJsonPath string
     */
    private validateFormSrc;
    private validateMainElementAndAbilities;
    /**
     * AtomicService相关校验
     *
     * @private
     */
    private validateAtomicService;
    /**
     * 获取元服务校验报错文件路径
     *
     * @param bundleType  app.json5-bundleType
     * @param installationFree  module.json5-installationFree
     * @private
     */
    private getAtomicServiceErrorPath;
    /**
     * 指定bundleType和installationFree字段校验
     *
     * @param bundleType  app.json5-bundleType
     * @param installationFree  module.json5-installationFree
     * @param cause cause
     * @private
     */
    private validateSpecificField;
    protected getJsonProfileByModel(): JsonProfile;
}
export interface FrameworkConfigurationOpt {
    frameworkType: string;
}
