"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.CommonSignCommandBuilder=void 0;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),error_code_map_js_1=require("../../../error/error-code-map.js"),decipher_util_js_1=require("../../../utils/decipher-util.js"),error_url_js_1=require("../../../utils/error-url.js"),ohos_logger_js_1=require("../../../utils/log/ohos-logger.js"),hvigor_1=require("@ohos/hvigor"),sdk_version_1=require("../../../version/sdk-version"),sdk_version_enum_1=require("../../../version/sdk-version-enum"),task_names_1=require("../../common/task-names");class CommonSignCommandBuilder{constructor(e,i,o,r,t){this._log=ohos_logger_js_1.OhosLogger.getLogger(CommonSignCommandBuilder.name),this._projectModel=e,this._signingConfig=i,this._sdkInfo=o,this._signModel=r,this._signingOptions=t;const s=this._sdkInfo.getToolchainsComponentVersion();void 0!==s&&(this._toolchainsComponentVersion=new sdk_version_1.SdkVersion(s))}getSignCommand(){const e=this._signingConfig.material;return this.checkValidMaterial(e),this.initCommandParams(e),this._signingOptions.addCalledJarFile(this.getSignTool()),this.codeSign(this._signingOptions.build())}codeSign(e){var i;const o=null===(i=this._toolchainsComponentVersion)||void 0===i?void 0:i.getVersion();if(void 0!==o&&o.startsWith("4.1.0")){const i=this._sdkInfo.getSdkVersion();void 0!==this._toolchainsComponentVersion&&(this._toolchainsComponentVersion.isHigherThan(sdk_version_enum_1.SdkVersionEnum.SUPPORT_CODE_SIGN)||this._toolchainsComponentVersion.equals(sdk_version_enum_1.SdkVersionEnum.SUPPORT_CODE_SIGN))&&(e.push("-signcode"),(!hvigor_1.hvigor.isCommandEntryTask(task_names_1.TaskNames.CommonHookTask.ASSEMBLE_APP.name)||hvigor_1.hvigor.isCommandEntryTask(task_names_1.TaskNames.CommonHookTask.ASSEMBLE_HQF.name))&&i>=11?e.push("1"):e.push("0"))}return e}getKeyStorePwd(){return decipher_util_js_1.DecipherUtil.decryptPwd(path_1.default.resolve(this._signingConfig.material.storeFile,".."),this._signingConfig.material.storePassword)}getKeyPwd(){return decipher_util_js_1.DecipherUtil.decryptPwd(path_1.default.resolve(this._signingConfig.material.storeFile,".."),this._signingConfig.material.keyPassword)}checkValidMaterial(e){const i="Please check signingConfigs in root project build-profile.json5";void 0===e&&this._log._buildError("The material has not been configured in signingConfigs.")._solution(i)._file(this._projectModel.getProfilePath())._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit(this._projectModel.getName()),this.validateMaterial(e.storeFile,i,"storeFile"),this.validateMaterial(e.profile,i,"profile"),this.validateMaterial(e.certpath,i,"certPath"),e.storeFile=this.normalizePath(e.storeFile),e.profile=this.normalizePath(e.profile),e.certpath=this.normalizePath(e.certpath)}normalizePath(e){return path_1.default.isAbsolute(e)?e:path_1.default.resolve(this._projectModel.getProjectDir(),e)}validateMaterial(e,i,o){if(void 0!==e&&fs_1.default.existsSync(this.normalizePath(e)))return;const r=`Invalid ${o} value. Make sure it is not null or empty. The file must be included in '${e}'.`;this._log._buildError(r)._solution(i)._file(this._projectModel.getProfilePath())._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit(this._projectModel.getName())}validateSignType(e){void 0===this._signingConfig.type&&(this._signingConfig.type="OpenHarmony"),this._signingConfig.type!==e&&this._log._buildError(`Signing configuration '${this._signingConfig.name}' does not apply to '${e}'. The HAP installation may fail.`)._solution(`see ${error_url_js_1.ErrorUrl.ERROR_URL.sign}`)._file(this._projectModel.getProfilePath())._errorCode(error_code_map_js_1.ECM.DECE.SERVICE_LOGIC)._printErrorAndExit(this._projectModel.getName())}}exports.CommonSignCommandBuilder=CommonSignCommandBuilder;