import premierlibrary from 'libpremierlibrary.so';
import { ObjCreateHelper } from '../utils/ObjCreateHelper';
import { ErrorInfo } from '../player/bean/ErrorInfo';
import { findErrorCodeByValue, PlayerErrorCode } from '../player/bean/PlayerErrorCode';
import { AliPlayerGlobalSettings } from '../player/AliPlayerGlobalSettings';
export class VodMediaLoader {
    constructor() {
        this.objHelper = new ObjCreateHelper();
        this.onPrepared = (w7) => {
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onPrepared(w7);
            }
        };
        this.onError = (s7, t7, u7, v7) => {
            console.log('VodMedialoader onError called, url: ' + s7 + " index " + t7 + " code: " + u7 + " msg " + v7);
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onError(s7, t7, u7, v7);
            }
            if (u7 != PlayerErrorCode.MEDIALOADER_ERROR_ADDED) {
                VodMediaLoader.getInstance().cancel(s7, t7);
            }
        };
        this.onErrorV2 = (m7, n7, o7, p7) => {
            console.log('VodMedialoader onErrorV2 called, url: ' + m7 + " index " + n7 + " code: " + o7 + " msg " + p7);
            if (this.mOnLoadStatusListener != null) {
                let q7 = findErrorCodeByValue(o7);
                let r7 = new ErrorInfo();
                r7.setCode(q7);
                r7.setMsg(p7);
                this.mOnLoadStatusListener.onErrorV2(m7, n7, r7);
            }
            if (o7 != PlayerErrorCode.MEDIALOADER_ERROR_ADDED) {
                VodMediaLoader.getInstance().cancel(m7, n7);
            }
        };
        this.onCompleted = (k7, l7) => {
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onCompleted(k7, l7);
            }
        };
        this.onCanceled = (i7, j7) => {
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onCanceled(i7, j7);
            }
        };
        premierlibrary.nVodMediaLoaderConstruct(this);
    }
    static getInstance() {
        if (!VodMediaLoader.sInstance) {
            VodMediaLoader.sInstance = new VodMediaLoader();
        }
        return VodMediaLoader.sInstance;
    }
    prepareVidStsSource(c7) {
        premierlibrary.nVodMediaLoaderPrepareSts(c7);
    }
    prepareVidAuthSource(b7) {
        premierlibrary.nVodMediaLoaderPrepareAuth(b7);
    }
    removeVidSource(a7) {
        premierlibrary.nVodMediaLoaderRemoveSource(a7);
    }
    load(v6, w6, x6) {
        if (!v6 || w6 < 0) {
            return;
        }
        let y6 = premierlibrary.nVodMediaLoaderGetVodUrl(v6, w6);
        let z6 = AliPlayerGlobalSettings.OnGetUrlHashCallbackInternal(y6);
        premierlibrary.nVodMediaLoaderLoad(v6, w6, z6, x6);
    }
    cancel(r6, s6) {
        let t6 = premierlibrary.nVodMediaLoaderGetVodUrl(r6, s6);
        let u6 = AliPlayerGlobalSettings.OnGetUrlHashCallbackInternal(t6);
        premierlibrary.nVodMediaLoaderCancel(r6, s6, u6);
    }
    pause(n6, o6) {
        if (!n6 || o6 < 0) {
            return;
        }
        let p6 = premierlibrary.nVodMediaLoaderGetVodUrl(n6, o6);
        let q6 = AliPlayerGlobalSettings.OnGetUrlHashCallbackInternal(p6);
        premierlibrary.nVodMediaLoaderPause(true, n6, o6, q6);
    }
    resume(j6, k6) {
        if (!j6 || k6 < 0) {
            return;
        }
        let l6 = premierlibrary.nVodMediaLoaderGetVodUrl(j6, k6);
        let m6 = AliPlayerGlobalSettings.OnGetUrlHashCallbackInternal(l6);
        premierlibrary.nVodMediaLoaderPause(false, j6, k6, m6);
    }
    setOnLoadStatusListener(i6) {
        this.mOnLoadStatusListener = i6;
    }
}
