import { AVPLBase } from './AVPLBase';
import { Log } from '../utils/Log';
import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
export class UrlVideoListPlayer extends AVPLBase {
    constructor(i47, j47) {
        super(i47, j47);
        this.mLog = new Log("NativePlayerBase_UrlVideoListPlayer");
        this.mUrlVideoPlayer = null;
        this.mUrlPrerenderPlayer = null;
    }
    setOnURLSourceExpiredListener(h47) {
        if (this.mUrlVideoPlayer != null) {
            this.mUrlVideoPlayer.setOnURLSourceExpiredListener(h47);
        }
    }
    createListPlayer(d47, e47, f47, g47) {
        return new OhosUrlListPlayer(d47, f47, g47, false);
    }
    getNativePlayerWithContext(b47, c47) {
        if (this.mUrlVideoPlayer == null) {
            this.mUrlVideoPlayer = new UrlVideoPlayer(b47, c47);
        }
        return this.mUrlVideoPlayer;
    }
    getPrerenderPlayerWithContext(z46, a47) {
        if (this.mUrlPrerenderPlayer == null) {
            this.mUrlPrerenderPlayer = new UrlVideoPlayer(z46, a47);
        }
        return this.mUrlPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let y46 = super.getCorePlayer();
        if (y46 instanceof OhosUrlListPlayer) {
            this.mLog.info("getCurrentPlayerIndex");
            return y46.getCurrentPlayerIndex();
        }
        return -1;
    }
    getPreRenderPlayer() {
        let w46 = super.getCorePlayer();
        if (w46 instanceof OhosUrlListPlayer) {
            this.mLog.info("getPreRenderPlayer");
            let x46 = w46.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(x46);
        }
        return undefined;
    }
    addUrl(t46, u46) {
        let v46 = super.getCorePlayer();
        if (v46 instanceof OhosUrlListPlayer) {
            this.mLog.info("addUrl = " + t46 + " , uid = " + u46);
            v46.addUrl(t46, u46);
        }
    }
    moveToNext() {
        let s46 = super.getCorePlayer();
        if (s46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNext");
            return s46.moveToNext(false);
        }
        return false;
    }
    moveToNextWithPrerendered() {
        let r46 = super.getCorePlayer();
        if (r46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNextWithPrerendered");
            return r46.moveToNext(true);
        }
        return false;
    }
    moveToPrev() {
        let q46 = super.getCorePlayer();
        if (q46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToPrev");
            return q46.moveToPrev();
        }
        return false;
    }
    moveTo(o46) {
        let p46 = super.getCorePlayer();
        if (p46 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveTo");
            return p46.moveTo(o46);
        }
        return false;
    }
    setUrlDataSource(m46) {
        let n46 = super.getNativePlayer();
        if (n46.setUrlDataSource !== undefined) {
            n46.setUrlDataSource(m46);
        }
    }
}
