import { NativePlayerBase } from './NativePlayerBase';
import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
const log = new Log('OhosUrlPlayer');
export class OhosUrlPlayer extends NativePlayerBase {
    setUrlDataSource(a36) {
        premierlibrary.nSetUrlDataSource(this, a36);
    }
    constructor(z35) {
        super(z35);
        this.mOnURLSourceExpiredListener = null;
    }
    setOnURLSourceExpiredListener(y35) {
        this.mOnURLSourceExpiredListener = y35;
    }
    refreshUrlSource(x35) {
        if (x35) {
            premierlibrary.nRefreshUrlSource(this, x35);
        }
    }
    refreshUrlSourceWithError(w35) {
        if (w35) {
            premierlibrary.nRefreshUrlSourceWithError(this, w35);
        }
    }
    onUrlSourceExpired(v35) {
        if (this.mOnURLSourceExpiredListener) {
            this.mOnURLSourceExpiredListener.onUrlSourceExpired(v35, null);
        }
    }
}
