export class BaseRequest {
    constructor(x49) {
        this.wantStop = false;
        this.outerListener = null;
        this.outerListener = x49;
    }
    getSync() {
        this.runInBackground();
    }
    getAsync() {
        this.runInBackgroundAsync();
    }
    runInBackgroundAsync() {
        setTimeout(() => {
            this.runInBackground();
        }, 0);
    }
    stop() {
        this.wantStop = true;
        this.stopInner();
    }
    sendSuccessResult(u49, v49) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onSuccess(u49, v49);
        }
    }
    sendFailResult(r49, s49, t49) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onFail(r49, s49, t49);
        }
    }
    dealMsg(q49) {
        if (q49.id == BaseRequest.WHAT_SUCCESS) {
            this.outerListener?.onSuccess(q49.data, q49.extra);
        }
        else if (q49.id == BaseRequest.WHAT_FAIL) {
            this.outerListener?.onFail(q49.failCode, q49.data, q49.extra);
        }
    }
}
BaseRequest.WHAT_SUCCESS = 1;
BaseRequest.WHAT_FAIL = 0;
BaseRequest.DATA_KEY_EXTRA = "data_extra";
