import { ALLOW_PRE_RENDER } from './IPlayer';
export class AVPLBase {
    constructor(o23, p23) {
        this.mNativePlayer = this.getNativePlayerWithContext(o23, p23);
        this.mPreRenderPlayer = this.getPrerenderPlayerWithContext(o23, p23);
        this.mListPlayer = this.createListPlayer(o23, p23, this.mNativePlayer.getNativeContextAddr(), this.mPreRenderPlayer.getNativeContextAddr());
    }
    getCurrentPlayer() {
        let n23 = this.getCurrentPlayerIndex();
        if (n23 == 1) {
            return this.mPreRenderPlayer;
        }
        else {
            return this.mNativePlayer;
        }
    }
    getCurrentPrerenderPlayer(m23) {
        if (m23 == 0) {
            return this.mNativePlayer;
        }
        else if (m23 == 1) {
            return this.mPreRenderPlayer;
        }
        return undefined;
    }
    getCorePlayer() {
        return this.mListPlayer;
    }
    getNativePlayer() {
        return this.mNativePlayer;
    }
    getPrerenderPlayer() {
        return this.mPreRenderPlayer;
    }
    removeSource(l23) {
        this.mListPlayer?.removeSource(l23);
    }
    clear() {
        this.mListPlayer?.clear();
    }
    getCurrentUid() {
        return this.mListPlayer?.getCurrentUid();
    }
    setMaxPreloadMemorySizeMB(k23) {
        this.mListPlayer?.setMaxPreloadMemorySizeMB(k23);
    }
    getMaxPreloadMemorySizeMB() {
        return this.mListPlayer?.getMaxPreloadMemorySizeMB();
    }
    SetMultiBitratesMode(j23) {
        this.mListPlayer?.SetMultiBitratesMode(j23);
    }
    GetMultiBitratesMode() {
        return this.mListPlayer?.GetMultiBitratesMode();
    }
    setPreloadCount(i23) {
        this.mListPlayer?.setPreloadCount(i23);
    }
    setPreloadScene(h23) {
        this.mListPlayer?.setPreloadScene(h23);
    }
    enablePreloadStrategy(f23, g23) {
        this.mListPlayer?.enablePreloadStrategy(f23, g23);
    }
    setPreloadStrategy(d23, e23) {
        this.mListPlayer?.setPreloadStrategyParam(d23, e23);
    }
    setPreloadCountWithPrevAndNext(b23, c23) {
        this.mListPlayer?.setPreloadCountWithPrevAndNext(b23, c23);
    }
    getNativeContextAddr() {
        return this.getCurrentPlayer()?.getNativeContextAddr();
    }
    prepare() {
        this.getCurrentPlayer().prepare();
    }
    start() {
        this.getCurrentPlayer()?.start();
    }
    pause() {
        this.getCurrentPlayer().pause();
    }
    stop() {
        this.getCurrentPlayer().stop();
    }
    setAutoPlay(a23) {
        this.getCurrentPlayer().setAutoPlay(a23);
    }
    setSurfaceId(z22) {
        this.getCurrentPlayer().setSurfaceId(z22);
    }
    setSpeed(y22) {
        this.getCurrentPlayer().setSpeed(y22);
    }
    setVolume(x22) {
        this.getCurrentPlayer().setVolume(x22);
    }
    getVolume() {
        return this.getCurrentPlayer().getVolume();
    }
    seekTo(v22, w22) {
        this.getCurrentPlayer().seekTo(v22, w22);
    }
    setStartTime(t22, u22) {
        this.getCurrentPlayer().setStartTime(t22, u22);
    }
    getDuration() {
        return this.getCurrentPlayer().getDuration();
    }
    getPlayedDuration() {
        return this.getCurrentPlayer().getPlayedDuration();
    }
    getCurrentPosition() {
        return this.getCurrentPlayer().getCurrentPosition();
    }
    getBufferedPosition() {
        return this.getCurrentPlayer().getBufferedPosition();
    }
    getPlayerStatus() {
        return this.getCurrentPlayer().getPlayerStatus();
    }
    enableHardwareDecoder(s22) {
        this.getCurrentPlayer().enableHardwareDecoder(s22);
    }
    release() {
        this.mListPlayer?.release();
        this.mNativePlayer?.release();
        this.mPreRenderPlayer?.release();
    }
    releaseAsync() {
        this.release();
    }
    setMute(r22) {
        this.getCurrentPlayer().setMute(r22);
    }
    isMuted() {
        return this.getCurrentPlayer().isMuted();
    }
    setScaleMode(q22) {
        this.getCurrentPlayer().setScaleMode(q22);
    }
    getScaleMode() {
        return this.getCurrentPlayer().getScaleMode();
    }
    setLoop(p22) {
        this.getCurrentPlayer().setLoop(p22);
    }
    isLoop() {
        return this.getCurrentPlayer().isLoop();
    }
    getVideoWidth() {
        return this.getCurrentPlayer().getVideoWidth();
    }
    getVideoHeight() {
        return this.getCurrentPlayer().getVideoHeight();
    }
    getVideoRotation() {
        return this.getCurrentPlayer().getVideoRotation();
    }
    reload() {
        this.getCurrentPlayer().reload();
    }
    setRotateMode(o22) {
        this.getCurrentPlayer().setRotateMode(o22);
    }
    getRotateMode() {
        return this.getCurrentPlayer().getRotateMode();
    }
    setMirrorMode(n22) {
        this.getCurrentPlayer().setMirrorMode(n22);
    }
    getMirrorMode() {
        return this.getCurrentPlayer().getMirrorMode();
    }
    setAlphaRenderMode(m22) {
        this.getCurrentPlayer().setAlphaRenderMode(m22);
    }
    getAlphaRenderMode() {
        return this.getCurrentPlayer().getAlphaRenderMode();
    }
    setVideoBackgroundColor(l22) {
        this.getCurrentPlayer().setVideoBackgroundColor(l22);
    }
    getSpeed() {
        return this.getCurrentPlayer().getSpeed();
    }
    isAutoPlay() {
        return this.getCurrentPlayer().isAutoPlay();
    }
    setConfig(k22) {
        if (this.mNativePlayer != null) {
            this.mNativePlayer.setConfig(k22);
        }
        if (this.mPreRenderPlayer != null) {
            this.mPreRenderPlayer.setConfig(k22);
        }
    }
    getConfig() {
        return this.getCurrentPlayer().getConfig();
    }
    setPlayerScene(j22) {
        this.getCurrentPlayer().setPlayerScene(j22);
    }
    setOption(h22, i22) {
        this.getCurrentPlayer().setOption(h22, i22);
    }
    setOptionNum(f22, g22) {
        this.getCurrentPlayer().setOptionNum(f22, g22);
        if (f22 == ALLOW_PRE_RENDER) {
            if (this.getCurrentPlayer() == this.mPreRenderPlayer) {
                this.mNativePlayer?.setOptionNum(f22, g22);
            }
            else {
                this.mPreRenderPlayer?.setOptionNum(f22, g22);
            }
        }
    }
    getOption(e22) {
        return this.getCurrentPlayer().getOption(e22);
    }
    selectTrack(d22) {
        this.getCurrentPlayer()?.selectTrack(d22);
    }
    switchStream(c22) {
        this.getCurrentPlayer()?.switchStream(c22);
    }
    getMediaInfo() {
        return this.getCurrentPlayer()?.getMediaInfo();
    }
    getSubMediaInfo() {
        return this.getCurrentPlayer()?.getSubMediaInfo();
    }
    currentTrack(b22) {
        return this.getCurrentPlayer()?.currentTrack(b22);
    }
    addExtSubtitle(a22) {
        this.getCurrentPlayer()?.addExtSubtitle(a22);
    }
    selectExtSubtitle(y21, z21) {
        this.getCurrentPlayer()?.selectExtSubtitle(y21, z21);
    }
    setStreamDelay(w21, x21) {
        this.getCurrentPlayer()?.setStreamDelay(w21, x21);
    }
    setMaxAccurateSeekDelta(v21) {
        this.getCurrentPlayer()?.setMaxAccurateSeekDelta(v21);
    }
    setCacheConfig(u21) {
        this.getCurrentPlayer()?.setCacheConfig(u21);
    }
    setIPResolveType(t21) {
        this.getCurrentPlayer()?.setIPResolveType(t21);
    }
    setFastStart(s21) {
        this.getCurrentPlayer()?.setFastStart(s21);
    }
    snapShot() {
        this.getCurrentPlayer()?.snapShot();
    }
    clearScreen() {
        this.getCurrentPlayer()?.clearScreen();
    }
    getCacheFilePathByUrl(r21) {
        return this.getCurrentPlayer()?.getCacheFilePathByUrl(r21) || '';
    }
    getCacheFilePathByVid(n21, o21, p21, q21) {
        return this.getCurrentPlayer()?.getCacheFilePathByVid(n21, o21, p21, q21) || '';
    }
    getPropertyString(m21) {
        return this.getCurrentPlayer()?.getPropertyString(m21) || '';
    }
    setDefaultBandWidth(l21) {
        this.getCurrentPlayer()?.setDefaultBandWidth(l21);
    }
    setDefaultAudioLanguage(k21) {
        this.getCurrentPlayer()?.setDefaultAudioLanguage(k21);
    }
    setDefaultResolution(j21) {
        this.getCurrentPlayer()?.setDefaultResolution(j21);
    }
    setAutoBandWidth(i21) {
        this.getCurrentPlayer()?.setAutoBandWidth(i21);
    }
    isAutoBandWidth() {
        return this.getCurrentPlayer()?.isAutoBandWidth() ?? false;
    }
    sendCustomEvent(h21) {
        this.getCurrentPlayer()?.sendCustomEvent(h21);
    }
    setVideoTag(g21) {
        this.getCurrentPlayer()?.setVideoTag(g21);
    }
    setUserData(f21) {
        this.getCurrentPlayer()?.setUserData(f21);
    }
    setTraceId(e21) {
        this.getCurrentPlayer()?.setTraceId(e21);
    }
    getUserData() {
        return this.getCurrentPlayer()?.getUserData() || '';
    }
    setOnPreparedListener(d21) {
        this.getCurrentPlayer().setOnPreparedListener(d21);
    }
    setOnInfoListener(c21) {
        this.getCurrentPlayer().setOnInfoListener(c21);
    }
    setOnRenderingStartListener(b21) {
        this.getCurrentPlayer().setOnRenderingStartListener(b21);
    }
    setOnStateChangedListener(a21) {
        this.getCurrentPlayer().setOnStateChangedListener(a21);
    }
    setOnCompletionListener(z20) {
        this.getCurrentPlayer().setOnCompletionListener(z20);
    }
    setOnLoadingStatusListener(y20) {
        this.getCurrentPlayer().setOnLoadingStatusListener(y20);
    }
    setOnAVNotSyncStatusListener(x20) {
        this.getCurrentPlayer()?.setOnAVNotSyncStatusListener(x20);
    }
    setOnNetworkStatsListener(w20) {
        this.getCurrentPlayer()?.setOnNetworkStatsListener(w20);
    }
    setOnErrorListener(v20) {
        this.getCurrentPlayer().setOnErrorListener(v20);
    }
    setOnVideoSizeChangedListener(u20) {
        this.getCurrentPlayer().setOnVideoSizeChangedListener(u20);
    }
    setOnSeekCompleteListener(t20) {
        this.getCurrentPlayer().setOnSeekCompleteListener(t20);
    }
    setOnSubtitleDisplayListener(s20) {
        this.getCurrentPlayer().setOnSubtitleDisplayListener(s20);
    }
    setOnVideoRenderedListener(r20) {
        this.getCurrentPlayer().setOnVideoRenderedListener(r20);
    }
    setOnAudioInterruptEventListener(q20) {
        this.getCurrentPlayer().setOnAudioInterruptEventListener(q20);
    }
    setOnSubTrackReadyListener(p20) {
        this.getCurrentPlayer()?.setOnSubTrackReadyListener(p20);
    }
    setOnTrackReadyListener(o20) {
        this.getCurrentPlayer()?.setOnTrackReadyListener(o20);
    }
    setOnTrackChangedListener(n20) {
        this.getCurrentPlayer()?.setOnTrackChangedListener(n20);
    }
    setOnSnapShotListener(m20) {
        this.getCurrentPlayer()?.setOnSnapShotListener(m20);
    }
    setOnSeiDataListener(l20) {
        this.getCurrentPlayer()?.setOnSeiDataListener(l20);
    }
    setOnStreamSwitchedListener(k20) {
        this.getCurrentPlayer()?.setOnStreamSwitchedListener(k20);
    }
    setOnUrlExpiredListener(j20) {
        this.getCurrentPlayer()?.setOnUrlExpiredListener(j20);
    }
}
