import premierlibrary from 'libpremierlibrary.so';
export class HlsKeyGenerator {
    static getInstance() {
        if (HlsKeyGenerator.instance == undefined) {
            HlsKeyGenerator.instance = new HlsKeyGenerator();
        }
        return HlsKeyGenerator.instance;
    }
    static setOnKeyGenerateListener(t24) {
        HlsKeyGenerator.getInstance().mOnKeyGenerateListener = t24;
    }
    constructor() {
        this.mOutKey = "default-key";
        this.getHlsOutKey = () => {
            return HlsKeyGenerator.getInstance().mOutKey;
        };
        this.onHlsKeyInfoInit = (q24, r24, s24) => {
            console.log('onHlsKeyInfoInit called.');
            if (this.mOnKeyGenerateListener != null) {
                this.mOnKeyGenerateListener.onHlsKeyInfoInit(q24, r24, s24);
            }
        };
        this.getHlsKey = (n24, o24) => {
            console.log('ongetHlsKey called.');
            if (this.mOnKeyGenerateListener != null) {
                let p24 = this.mOnKeyGenerateListener.getHlsKey(n24, o24);
                this.mOutKey = p24;
                console.log("get hlsKey, key: " + p24);
                return p24;
            }
            return "";
        };
        this.getHlsKeyInternal = () => {
            if (this.mOutKey) {
                return this.mOutKey;
            }
            return "";
        };
        premierlibrary.nHlsGenConstruct(this);
    }
}
