import { AVPBase } from './AVPBase';
import { OhosUrlPlayer } from './nativeclass/OhosUrlPlayer';
import { UrlSource } from './source/UrlSource';
class URLSourceRefreshCallback {
    constructor(e48) {
        this.urlVideoPlayer = e48;
    }
    onSuccess(d48) {
        this.urlVideoPlayer.refreshUrlSource(d48);
    }
    onError(c48) {
        this.urlVideoPlayer.refreshUrlSourceWithError(c48);
    }
}
class URLSourceExpiredListener {
    constructor(b48) {
        this.urlVideoPlayer = b48;
    }
    onUrlSourceExpired(y47, z47) {
        const a48 = new URLSourceRefreshCallback(this.urlVideoPlayer);
        this.urlVideoPlayer.onUrlSourceExpired(y47, a48);
    }
}
export class UrlVideoPlayer extends AVPBase {
    constructor(w47, x47) {
        super(w47, x47);
        this.mOutOnURLSourceExpiredListener = null;
    }
    createAlivcMediaPlayer(u47) {
        let v47 = new OhosUrlPlayer(u47);
        v47.setOnURLSourceExpiredListener(new URLSourceExpiredListener(this));
        return v47;
    }
    setUrlDataSource(s47) {
        let t47 = this.getCorePlayer();
        if (t47 instanceof OhosUrlPlayer) {
            if (s47 instanceof UrlSource) {
                t47.setUrlDataSource(s47);
            }
        }
    }
    setOnURLSourceExpiredListener(r47) {
        this.mOutOnURLSourceExpiredListener = r47;
    }
    onUrlSourceExpired(o47, p47) {
        if (this.mOutOnURLSourceExpiredListener) {
            const q47 = new URLSourceRefreshCallback(this);
            this.mOutOnURLSourceExpiredListener.onUrlSourceExpired(o47, q47);
        }
    }
    refreshUrlSource(m47) {
        let n47 = this.getCorePlayer();
        if (n47 instanceof OhosUrlPlayer) {
            n47.refreshUrlSource(m47);
        }
    }
    refreshUrlSourceWithError(k47) {
        let l47 = this.getCorePlayer();
        if (l47 instanceof OhosUrlPlayer) {
            l47.refreshUrlSourceWithError(k47);
        }
    }
}
