export class VidPlayerConfigGen {
    constructor() {
        this.configMap = new Map();
    }
    addPlayerConfigNumber(p48, q48) {
        if (p48 != null) {
            this.configMap.set(p48, q48);
        }
    }
    addPlayerConfigString(n48, o48) {
        if (n48 != null) {
            this.configMap.set(n48, o48);
        }
    }
    setPreviewTime(m48) {
        this.addPlayerConfigNumber("PreviewTime", m48);
    }
    setEncryptType(l48) {
        if (l48 == EncryptType.AliyunVodEncryption) {
            this.addPlayerConfigString("EncryptType", "AliyunVoDEncryption");
        }
        else if (l48 == EncryptType.HLSEncryption) {
            this.addPlayerConfigString("EncryptType", "HLSEncryption");
        }
        else if (l48 == EncryptType.Unencrypted) {
            this.addPlayerConfigString("EncryptType", "Unencrypted");
        }
    }
    setMtsHlsUriToken(k48) {
        this.addPlayerConfigString("MtsHlsUriToken", k48);
    }
    genConfig() {
        let g48 = {};
        if (this.configMap.size == 0) {
            return "";
        }
        this.configMap.forEach((i48, j48) => {
            if (j48 != undefined && i48 != undefined) {
                g48[j48] = i48;
            }
        });
        return JSON.stringify(g48);
    }
}
export var EncryptType;
(function (f48) {
    f48[f48["Unencrypted"] = 0] = "Unencrypted";
    f48[f48["AliyunVodEncryption"] = 1] = "AliyunVodEncryption";
    f48[f48["HLSEncryption"] = 2] = "HLSEncryption";
})(EncryptType || (EncryptType = {}));
