import http from '@ohos.net.http';
import util from "@ohos.util";
export class HttpClientHelper {
    constructor(u50) {
        this.mReferer = null;
        this.urlRequest = null;
        this.mNetworkTimeout = HttpClientHelper.CONNECTION_TIMEOUT;
        this.mHttpProxy = null;
        this.mUserAgent = null;
        this.mCustomHeaders = [{}];
        this.mUrl = u50;
    }
    setRefer(t50) {
        this.mReferer = t50;
    }
    setTimeout(s50) {
        this.mNetworkTimeout = s50;
    }
    setHttpProxy(r50) {
        this.mHttpProxy = r50;
    }
    setUserAgent(q50) {
        this.mUserAgent = q50;
    }
    setCustomHeaders(p50) {
        this.mCustomHeaders = p50;
    }
    stop() {
        if (this.urlRequest != null) {
            setTimeout(() => {
                this.urlRequest?.destroy();
            }, 0);
        }
    }
    async doGet() {
        if (this.mUrl.startsWith("https://") || this.mUrl.startsWith("http://")) {
            this.urlRequest = http.createHttp();
        }
        else {
            return null;
        }
        if (this.urlRequest == null) {
            return null;
        }
        let b50 = [];
        if (this.mReferer != null) {
            b50.push({ 'Referer': this.mReferer });
        }
        if (this.mUserAgent != null) {
            b50.push({ 'User-Agent': this.mUserAgent });
        }
        if (this.mCustomHeaders.length > 0) {
            for (let n50 of this.mCustomHeaders) {
                if (n50 != null) {
                    b50.push(n50);
                }
            }
        }
        let c50 = "";
        let d50 = false;
        if (this.mHttpProxy != null) {
            c50 = this.mHttpProxy;
            d50 = true;
        }
        else {
            c50 = this.mUrl;
        }
        let e50 = {
            method: http.RequestMethod.GET,
            header: b50,
            connectTimeout: this.mNetworkTimeout,
            readTimeout: this.mNetworkTimeout,
            usingProxy: d50,
        };
        return new Promise((g50, h50) => {
            if (this.urlRequest == null) {
                g50(null);
                return;
            }
            this.urlRequest.request(c50, e50, (j50, k50) => {
                if (j50) {
                    console.error('error:' + JSON.stringify(j50));
                    this.urlRequest?.destroy();
                    g50(null);
                    return;
                }
                if (k50.responseCode == http.ResponseCode.OK) {
                    if (k50.resultType == http.HttpDataType.STRING) {
                        g50(k50.result);
                    }
                    else if (k50.resultType == http.HttpDataType.ARRAY_BUFFER) {
                        let l50 = util.TextDecoder.create('utf-8');
                        let m50 = l50.decodeToString(new Uint8Array(k50.result));
                        g50(m50 ? m50 : null);
                    }
                    else {
                        console.info("response failed, resultType: " + k50.resultType);
                        this.urlRequest?.destroy();
                        g50(null);
                    }
                }
                else {
                    console.info("response failed, responseCode is " + k50.responseCode);
                    this.urlRequest?.destroy();
                    g50(null);
                }
            });
        });
    }
}
HttpClientHelper.CONNECTION_TIMEOUT = 10000;
