import premierlibrary from 'libpremierlibrary.so';
export class Logger {
    constructor() {
        this.mValue = -1;
        this.mLogCallback = null;
        this.mEnableConsoleLog = true;
        this.mCurrentLogLevel = LogLevel.AF_LOG_LEVEL_INFO;
        this.nOnLogCallback = (r51, s51) => {
            let t51 = Logger.getLevel(r51);
            if (Logger.sAppContext != null) {
                Logger.getInstance(Logger.sAppContext).callback(t51, s51);
            }
        };
        premierlibrary.nLoggerConstruct(this);
    }
    static getInstance(p51) {
        if (Logger.sInstance == null) {
            Logger.sInstance = new Logger();
            Logger.sInstance.setLogLevel(LogLevel.AF_LOG_LEVEL_INFO);
            if (p51 != null) {
                Logger.sAppContext = p51;
            }
        }
        return Logger.sInstance;
    }
    setLogCallback(o51) {
        this.mLogCallback = o51;
    }
    getLogCallback() {
        return this.mLogCallback;
    }
    setLogLevel(n51) {
        this.mCurrentLogLevel = n51;
        premierlibrary.nLoggerSetLevel(n51);
    }
    setLogOption(l51, m51) {
        switch (l51) {
            case LogOption.FRAME_LEVEL_LOGGING_ENABLED:
                premierlibrary.nLoggerSetOption("frame_level_logging_enabled", m51);
                break;
        }
    }
    getLogLevel() {
        let k51 = premierlibrary.nLoggerGetLevel();
        return Logger.getLevel(k51);
    }
    enableConsoleLog(j51) {
        this.mEnableConsoleLog = j51;
        premierlibrary.nLoggerEnableConsole(j51);
    }
    callback(h51, i51) {
        if (this.mLogCallback != null) {
            this.mLogCallback.onLog(h51, i51);
        }
    }
    static getLevel(g51) {
        switch (g51) {
            case 0:
                return LogLevel.AF_LOG_LEVEL_NONE;
            case 8:
                return LogLevel.AF_LOG_LEVEL_FATAL;
            case 16:
                return LogLevel.AF_LOG_LEVEL_ERROR;
            case 24:
                return LogLevel.AF_LOG_LEVEL_WARNING;
            case 32:
                return LogLevel.AF_LOG_LEVEL_INFO;
            case 48:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
            case 56:
                return LogLevel.AF_LOG_LEVEL_TRACE;
            default:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
        }
    }
}
export var LogLevel;
(function (f51) {
    f51[f51["AF_LOG_LEVEL_NONE"] = 0] = "AF_LOG_LEVEL_NONE";
    f51[f51["AF_LOG_LEVEL_FATAL"] = 8] = "AF_LOG_LEVEL_FATAL";
    f51[f51["AF_LOG_LEVEL_ERROR"] = 16] = "AF_LOG_LEVEL_ERROR";
    f51[f51["AF_LOG_LEVEL_WARNING"] = 24] = "AF_LOG_LEVEL_WARNING";
    f51[f51["AF_LOG_LEVEL_INFO"] = 32] = "AF_LOG_LEVEL_INFO";
    f51[f51["AF_LOG_LEVEL_DEBUG"] = 48] = "AF_LOG_LEVEL_DEBUG";
    f51[f51["AF_LOG_LEVEL_TRACE"] = 56] = "AF_LOG_LEVEL_TRACE";
})(LogLevel || (LogLevel = {}));
export var LogOption;
(function (e51) {
    e51[e51["FRAME_LEVEL_LOGGING_ENABLED"] = 1] = "FRAME_LEVEL_LOGGING_ENABLED";
})(LogOption || (LogOption = {}));
