/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.decoder;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Surface;
import java.util.concurrent.CountDownLatch;

public class DecoderSurfaceTexture
implements SurfaceTexture.OnFrameAvailableListener {
    private static final int CREATE_SURFACE_MSG = 12345;
    private int mTextureId = 0;
    private long mDecoderHandler = 0L;
    private SurfaceTexture mSurfaceTexture = null;
    private Surface mSurface = null;
    private HandlerThread mHandleThread = new HandlerThread("DecoderSurfaceTexture");
    private Handler mHandler = null;
    private CountDownLatch mCountDown = new CountDownLatch(1);

    public DecoderSurfaceTexture() {
        this.mHandleThread.start();
    }

    public Surface createSurface(int id, long handler) {
        if (id <= 0) {
            return null;
        }
        this.mTextureId = id;
        this.mDecoderHandler = handler;
        try {
            this.mHandler = new Handler(this.mHandleThread.getLooper()){

                public void handleMessage(Message msg) {
                    if (msg.what == 12345) {
                        DecoderSurfaceTexture.this.mSurfaceTexture = new SurfaceTexture(DecoderSurfaceTexture.this.mTextureId);
                        DecoderSurfaceTexture.this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)((DecoderSurfaceTexture)msg.obj));
                        DecoderSurfaceTexture.this.mSurface = new Surface(DecoderSurfaceTexture.this.mSurfaceTexture);
                        DecoderSurfaceTexture.this.mCountDown.countDown();
                    } else {
                        super.handleMessage(msg);
                    }
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message msg = new Message();
        msg.what = 12345;
        msg.obj = this;
        this.mHandler.sendMessage(msg);
        try {
            this.mCountDown.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mSurface;
    }

    public void getTransformMatrix(float[] matrix) {
        if (this.mSurfaceTexture == null) {
            return;
        }
        this.mSurfaceTexture.getTransformMatrix(matrix);
    }

    public void updateTexImage() {
        this.mSurfaceTexture.updateTexImage();
    }

    public void dispose() {
        this.mSurface.release();
        this.mHandleThread.quit();
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.onFrameAvailable(this.mDecoderHandler);
    }

    private native void onFrameAvailable(long var1);
}

