/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.annotation.TargetApi;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import com.alivc.component.encoder.NativeUsed;
import java.nio.ByteBuffer;

@TargetApi(value=19)
public class SurfaceReader {
    private static final String TAG = "SurfaceReader";
    private ImageReader mReader;
    private ImageReader.OnImageAvailableListener mOnImageAvailableListener;
    private HandlerThread mBackgroundThread = new HandlerThread("SurfaceReader");
    private Handler mBackgroundHandler;
    private long mBufferCallback = 0L;
    private long timeStamp = 0L;

    public SurfaceReader(int width, int height, int format, int maxImages) {
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        this.mReader = ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages);
        Log.e((String)TAG, (String)("ImageReader format " + this.mReader.getImageFormat() + "maximage" + this.mReader.getMaxImages()));
        this.mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader imageReader) {
                Image image = imageReader.acquireNextImage();
                if (image == null) {
                    return;
                }
                if (image.getFormat() == 1) {
                    SurfaceReader.this.nativeWriteRGBABuffer(SurfaceReader.this.mBufferCallback, image.getPlanes()[0].getRowStride(), image.getWidth(), image.getHeight(), SurfaceReader.this.timeStamp, image.getPlanes()[0].getBuffer());
                    SurfaceReader.this.timeStamp = SurfaceReader.this.timeStamp + 40000L;
                } else {
                    int length = image.getPlanes().length;
                    ByteBuffer[] buffers = new ByteBuffer[length];
                    for (int i = 0; i < length; ++i) {
                        buffers[i] = image.getPlanes()[i].getBuffer();
                    }
                    SurfaceReader.this.nativeWriteYUV420Buffer(SurfaceReader.this.mBufferCallback, image.getWidth(), image.getHeight(), SurfaceReader.this.timeStamp, buffers);
                    SurfaceReader.this.timeStamp = SurfaceReader.this.timeStamp + 40000L;
                }
                image.close();
            }
        };
        this.mReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
    }

    @NativeUsed
    public void release() {
        if (this.mReader != null) {
            Image image = this.mReader.acquireLatestImage();
            if (image != null) {
                image.close();
            }
            this.mReader.close();
        }
        this.mReader = null;
        this.mOnImageAvailableListener = null;
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            Log.d((String)TAG, (String)"setting background handler to null");
            this.mBackgroundHandler = null;
            Log.d((String)TAG, (String)"background handler is now null");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @NativeUsed
    public void setBufferCallback(long nativeCallback) {
        this.mBufferCallback = nativeCallback;
    }

    @NativeUsed
    public Surface getSurface() {
        if (this.mReader != null) {
            return this.mReader.getSurface();
        }
        return null;
    }

    private native void nativeWriteRGBABuffer(long var1, int var3, int var4, int var5, long var6, ByteBuffer var8);

    private native void nativeWriteYUV420Buffer(long var1, int var3, int var4, long var5, ByteBuffer[] var7);
}

