/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import com.alivc.component.encoder.MediaCodecData;
import com.alivc.component.encoder.NativeUsed;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;

@NativeUsed
public class VideoCodecEncoder {
    public static final int[] SUPPORTED_COLOR_FORMATS = new int[]{21, 39, 19, 20, 2130706688};
    public static final String VERSION = "1.2.2";
    public static final int OK = 0;
    public static final int ERROR_API_LEVEL = 0x10003100;
    public static final int ERROR_STATE = 0x10003101;
    public static final int ERROR_INPUT_BUFFER_ERROR = 268448002;
    public static final int ERROR_NO_BUFFER_AVAILABLE = 0x10003103;
    private static final String TAG = VideoCodecEncoder.class.getName() + " version" + "1.2.2";
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_ENCODING = 2;
    private MediaCodec mMediaCodec;
    private int mState = 0;
    private ByteBuffer[] mOutputBuffers;
    private int encodeFormat = -1;
    private int mOutputCount = 0;
    private Surface mSurface = null;

    @NativeUsed
    public int initWithColorSpace(String mimeType, MediaFormat format, boolean inputSurface, int gopSize, int colorStand, int colorRange) {
        if (this.mState == 0) {
            try {
                this.mOutputCount = 0;
                MediaCodecInfo codecInfo = this.selectCodecInfo(mimeType);
                if (codecInfo == null) {
                    Log.e((String)TAG, (String)("not supported mime type (" + mimeType + ")"));
                    return -1;
                }
                Log.d((String)TAG, (String)("Create MediaCodec " + codecInfo.getName() + " version " + VERSION));
                this.mMediaCodec = MediaCodec.createByCodecName((String)codecInfo.getName());
                MediaCodecInfo.CodecCapabilities cap = codecInfo.getCapabilitiesForType(mimeType);
                Log.i((String)TAG, (String)Arrays.toString(cap.colorFormats));
                this.encodeFormat = VideoCodecEncoder.selectColorFormat(codecInfo, inputSurface, mimeType);
                if (this.encodeFormat == 0) {
                    return -1;
                }
                Log.i((String)TAG, (String)("selected format " + this.encodeFormat));
                format.setInteger("color-format", this.encodeFormat);
                int fps = format.getInteger("frame-rate");
                format.setInteger("i-frame-interval", gopSize);
                format.setInteger("profile", 1);
                format.setInteger("level", 512);
                if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 29) {
                    Method method = MediaCodecInfo.VideoCapabilities.class.getMethod("create", MediaFormat.class, MediaCodecInfo.CodecCapabilities.class);
                    MediaCodecInfo.VideoCapabilities vcap = (MediaCodecInfo.VideoCapabilities)method.invoke(null, format, cap);
                    Range bitrateRange = vcap.getBitrateRange();
                    int widthAlignment = vcap.getWidthAlignment();
                    int heightAlignment = vcap.getHeightAlignment();
                    Range widthRange = vcap.getSupportedWidths();
                    Range heightRange = vcap.getSupportedHeights();
                    int width = format.getInteger("width");
                    int height = format.getInteger("height");
                    int frameRate = format.getInteger("frame-rate");
                    boolean isSizeSupport = vcap.isSizeSupported(width, height);
                    Log.i((String)TAG, (String)("bitrateRange [" + bitrateRange.getLower() + "," + bitrateRange.getUpper() + "], widthAlignment = " + widthAlignment + ", heightAlignment = " + heightAlignment + ", widthRange [" + widthRange.getLower() + "," + widthRange.getUpper() + "], heightRange [" + heightRange.getLower() + "," + heightRange.getUpper() + "], isSizeSupport = " + isSizeSupport + ", sizeAndRateSupport = " + vcap.areSizeAndRateSupported(width, height, (double)frameRate)));
                    if (Build.VERSION.SDK_INT >= 23) {
                        format.setInteger("stride", width);
                        format.setInteger("slice-height", height);
                    }
                }
                if (Build.VERSION.SDK_INT >= 24) {
                    colorStand = colorStand == 0 ? 2 : colorStand;
                    int n = colorRange = colorRange == 0 ? 2 : colorRange;
                    if (1 == colorStand || 2 == colorStand || 6 == colorStand) {
                        format.setInteger("color-standard", colorStand);
                        format.setInteger("color-transfer", 3);
                    }
                    if (1 == colorRange || 2 == colorRange) {
                        format.setInteger("color-range", colorRange);
                    }
                } else {
                    Log.i((String)TAG, (String)("Build.VERSION.SDK_INT = " + Build.VERSION.SDK_INT + " is lower than 24"));
                }
                Log.i((String)TAG, (String)("encoder bitrate = " + format.getInteger("bitrate") + ", encoder i frame interval = " + format.getInteger("i-frame-interval") + ", encoder frame rate = " + format.getInteger("frame-rate") + ", encoder profile = " + format.getInteger("profile") + ", encoder level = " + format.getInteger("level") + ", encoder width = " + format.getInteger("width") + ", encoder height = " + format.getInteger("height") + ", colorStand = " + colorStand + ", colorRange = " + colorRange));
                this.mMediaCodec.configure(format, null, null, 1);
                this.mState = 1;
                if ("OMX.IMG.TOPAZ.VIDEO.Encoder".equals(codecInfo.getName())) {
                    Log.i((String)TAG, (String)("Product:" + Build.PRODUCT));
                    switch (this.encodeFormat) {
                        case 19: {
                            this.encodeFormat = 20;
                            break;
                        }
                        case 20: {
                            this.encodeFormat = 19;
                            break;
                        }
                        case 21: {
                            this.encodeFormat = 39;
                            break;
                        }
                        case 39: {
                            this.encodeFormat = 21;
                            break;
                        }
                    }
                }
                return this.encodeFormat;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Create MediaCodec Failed");
                e.printStackTrace();
                return 0x10003101;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0x10003101;
            }
        }
        return 0x10003101;
    }

    @NativeUsed
    public int init(String mimeType, MediaFormat format, boolean inputSurface, int gopSize) {
        if (this.mState == 0) {
            try {
                this.mOutputCount = 0;
                MediaCodecInfo codecInfo = this.selectCodecInfo(mimeType);
                if (codecInfo == null) {
                    Log.d((String)TAG, (String)("not supported mime type (" + mimeType + ")"));
                    return -1;
                }
                Log.i((String)TAG, (String)("Create MediaCodec " + codecInfo.getName()));
                this.mMediaCodec = MediaCodec.createByCodecName((String)codecInfo.getName());
                MediaCodecInfo.CodecCapabilities cap = codecInfo.getCapabilitiesForType(mimeType);
                Log.i((String)TAG, (String)Arrays.toString(cap.colorFormats));
                this.encodeFormat = VideoCodecEncoder.selectColorFormat(codecInfo, inputSurface, mimeType);
                if (this.encodeFormat == 0) {
                    return -1;
                }
                Log.i((String)TAG, (String)("selected format " + this.encodeFormat));
                format.setInteger("color-format", this.encodeFormat);
                int fps = format.getInteger("frame-rate");
                format.setInteger("i-frame-interval", gopSize);
                format.setInteger("profile", 1);
                format.setInteger("level", 512);
                if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 29) {
                    Method method = MediaCodecInfo.VideoCapabilities.class.getMethod("create", MediaFormat.class, MediaCodecInfo.CodecCapabilities.class);
                    MediaCodecInfo.VideoCapabilities vcap = (MediaCodecInfo.VideoCapabilities)method.invoke(null, format, cap);
                    Range bitrateRange = vcap.getBitrateRange();
                    int widthAlignment = vcap.getWidthAlignment();
                    int heightAlignment = vcap.getHeightAlignment();
                    Range widthRange = vcap.getSupportedWidths();
                    Range heightRange = vcap.getSupportedHeights();
                    int width = format.getInteger("width");
                    int height = format.getInteger("height");
                    int frameRate = format.getInteger("frame-rate");
                    boolean isSizeSupport = vcap.isSizeSupported(width, height);
                    Log.i((String)TAG, (String)("bitrateRange [" + bitrateRange.getLower() + "," + bitrateRange.getUpper() + "], widthAlignment = " + widthAlignment + ", heightAlignment = " + heightAlignment + ", widthRange [" + widthRange.getLower() + "," + widthRange.getUpper() + "], heightRange [" + heightRange.getLower() + "," + heightRange.getUpper() + "], isSizeSupport = " + isSizeSupport + ", sizeAndRateSupport = " + vcap.areSizeAndRateSupported(width, height, (double)frameRate)));
                    if (Build.VERSION.SDK_INT >= 23) {
                        format.setInteger("stride", width);
                        format.setInteger("slice-height", height);
                    }
                }
                Log.i((String)TAG, (String)("encoder bitrate = " + format.getInteger("bitrate") + ", encoder i frame interval = " + format.getInteger("i-frame-interval") + ", encoder frame rate = " + format.getInteger("frame-rate") + ", encoder profile = " + format.getInteger("profile") + ", encoder level = " + format.getInteger("level") + ", encoder width = " + format.getInteger("width") + ", encoder height = " + format.getInteger("height")));
                this.mMediaCodec.configure(format, null, null, 1);
                this.mState = 1;
                if ("OMX.IMG.TOPAZ.VIDEO.Encoder".equals(codecInfo.getName())) {
                    Log.i((String)TAG, (String)("Product:" + Build.PRODUCT));
                    switch (this.encodeFormat) {
                        case 19: {
                            this.encodeFormat = 20;
                            break;
                        }
                        case 20: {
                            this.encodeFormat = 19;
                            break;
                        }
                        case 21: {
                            this.encodeFormat = 39;
                            break;
                        }
                        case 39: {
                            this.encodeFormat = 21;
                            break;
                        }
                    }
                }
                return this.encodeFormat;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Create MediaCodec Failed");
                e.printStackTrace();
                return 0x10003101;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0x10003101;
            }
        }
        return 0x10003101;
    }

    @NativeUsed
    @RequiresApi(api=23)
    public int setInputSurface(Surface surface) {
        if (this.mMediaCodec != null && this.mState == 1 && Build.VERSION.SDK_INT >= 18) {
            try {
                this.mMediaCodec.setInputSurface(surface);
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"set input surface failed");
                return -1;
            }
        }
        Log.e((String)TAG, (String)("error state codec " + this.mMediaCodec));
        return -1;
    }

    @NativeUsed
    public Surface createInputSurface() {
        if (this.mMediaCodec != null && this.mState == 1 && Build.VERSION.SDK_INT >= 18) {
            try {
                if (this.mSurface == null) {
                    this.mSurface = this.mMediaCodec.createInputSurface();
                }
                return this.mSurface;
            }
            catch (Exception e) {
                this.mSurface = null;
                e.printStackTrace();
                Log.e((String)TAG, (String)"create surface input failed");
                return null;
            }
        }
        Log.e((String)TAG, (String)"not support surface input");
        return null;
    }

    @NativeUsed
    public int start() {
        if (this.mMediaCodec != null && this.mState == 1) {
            try {
                this.mMediaCodec.start();
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0x10003101;
            }
            this.mState = 2;
            return 0;
        }
        return 0x10003101;
    }

    @NativeUsed
    public int inputFrame(byte[] frame, long presentationTimeUs, long timeoutUs, boolean isKeyFrame) {
        try {
            ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
            int bufferIndex = this.mMediaCodec.dequeueInputBuffer(timeoutUs);
            if (bufferIndex >= 0) {
                inputBuffers[bufferIndex].clear();
                if (frame == null) {
                    Log.e((String)TAG, (String)"Symptom of the \"Callback buffer was to small\" problem...");
                } else {
                    inputBuffers[bufferIndex].put(frame, 0, frame.length);
                }
                if (isKeyFrame && Build.VERSION.SDK_INT >= 19) {
                    Bundle params = new Bundle();
                    params.putInt("request-sync", 0);
                    this.mMediaCodec.setParameters(params);
                }
            } else {
                Log.d((String)TAG, (String)"No buffer available !");
                return 0x10003103;
            }
            int flag = isKeyFrame ? 1 : 0;
            this.mMediaCodec.queueInputBuffer(bufferIndex, 0, inputBuffers[bufferIndex].position(), presentationTimeUs, flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    @NativeUsed
    public MediaCodecData tryRead(long timeoutUs) {
        MediaCodec.BufferInfo outputBufferInfo = new MediaCodec.BufferInfo();
        ByteBuffer outputBuffer = null;
        MediaCodecData resultData = new MediaCodecData();
        try {
            int outputBufferId = this.mMediaCodec.dequeueOutputBuffer(outputBufferInfo, timeoutUs);
            if (outputBufferId >= 0) {
                outputBuffer = this.mOutputBuffers[outputBufferId];
                if (outputBufferInfo.size != 0) {
                    outputBuffer.position(outputBufferInfo.offset);
                    outputBuffer.limit(outputBufferInfo.offset + outputBufferInfo.size);
                }
                resultData.setCodecData(outputBuffer, this.mMediaCodec, outputBufferId);
                if ((outputBufferInfo.flags & 2) > 0) {
                    resultData.setDataType(1);
                } else if ((outputBufferInfo.flags & 1) > 0) {
                    resultData.setDataType(3);
                    ++this.mOutputCount;
                } else {
                    resultData.setDataType(2);
                    ++this.mOutputCount;
                }
                resultData.setPts(outputBufferInfo.presentationTimeUs);
                resultData.setDts(outputBufferInfo.presentationTimeUs);
                if ((outputBufferInfo.flags & 4) > 0) {
                    resultData.setEos(true);
                } else {
                    resultData.setEos(false);
                }
            } else if (outputBufferId == -2) {
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                resultData.setCode(1);
            } else if (outputBufferId == -1) {
                resultData.setCode(1);
            } else if (outputBufferId == -3) {
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                resultData.setCode(1);
            } else {
                resultData.setCode(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultData;
    }

    @NativeUsed
    public int updateBitrate(int bitrate) {
        if (Build.VERSION.SDK_INT < 19) {
            return 0x10003100;
        }
        if (this.mState == 2 && this.mMediaCodec != null) {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", bitrate * 1000);
            try {
                this.mMediaCodec.setParameters(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
        return 0x10003101;
    }

    @NativeUsed
    public int signalEndOfInput() {
        try {
            this.mMediaCodec.signalEndOfInputStream();
            return 0;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"signalEndOfInputStream failed");
            e.printStackTrace();
            return -1;
        }
    }

    @NativeUsed
    public int stop() {
        if (this.mState == 2 && this.mMediaCodec != null) {
            try {
                if (this.mOutputCount > 0) {
                    this.mMediaCodec.flush();
                }
                this.mMediaCodec.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0x10003101;
            }
            this.mState = 1;
            return 0;
        }
        return 0x10003101;
    }

    @NativeUsed
    public int release() {
        if (this.mState == 1) {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
            this.mState = 0;
            return 0;
        }
        return 0x10003101;
    }

    private MediaCodecInfo selectCodecInfo(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return null;
    }

    private static int selectColorFormat(MediaCodecInfo codecInfo, boolean inputSurface, String mimeType) {
        if (inputSurface) {
            return 2130708361;
        }
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(mimeType);
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            int colorFormat = capabilities.colorFormats[i];
            if (!VideoCodecEncoder.isRecognizedFormat(colorFormat)) continue;
            return colorFormat;
        }
        return 0;
    }

    private static boolean isRecognizedFormat(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: 
            case 21: 
            case 39: 
            case 2130706688: {
                return true;
            }
        }
        return false;
    }
}

