/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.media.MediaCodec;
import android.os.Build;
import android.util.Log;
import com.alivc.component.encoder.NativeUsed;
import java.nio.ByteBuffer;

@NativeUsed
public class MediaCodecData {
    public static final int DATA_TYPE_SPECIFIC = 1;
    public static final int DATA_NORMAL_FRAME = 2;
    public static final int DATA_KEY_FRAME = 3;
    public static final int ERROR_CODE_OK = 0;
    public static final int ERROR_CODE_TRY_AGAIN = 1;
    public static final int ERROR_UNKNOWN = -1;
    private int mDataType;
    private int mCode;
    private long mPts;
    private long mDts;
    private ByteBuffer mCodecData;
    private MediaCodec mMediaCodec;
    private int mOutputBufferId;
    private boolean isEos;

    @NativeUsed
    public int getDataType() {
        return this.mDataType;
    }

    public void setDataType(int dataType) {
        this.mDataType = dataType;
    }

    @NativeUsed
    public int getCode() {
        return this.mCode;
    }

    public void setCode(int code) {
        this.mCode = code;
    }

    @NativeUsed
    public long getPts() {
        return this.mPts;
    }

    public void setPts(long pts) {
        this.mPts = pts;
    }

    @NativeUsed
    public long getDts() {
        return this.mDts;
    }

    public void setDts(long dts) {
        this.mDts = dts;
    }

    @NativeUsed
    public ByteBuffer getCodecData() {
        return this.mCodecData;
    }

    public void setCodecData(ByteBuffer codecData, MediaCodec mediaCodec, int outputBufferId) {
        this.mCodecData = codecData;
        this.mMediaCodec = mediaCodec;
        this.mOutputBufferId = outputBufferId;
    }

    public int getPosition() {
        return this.mCodecData == null ? 0 : this.mCodecData.limit();
    }

    @NativeUsed
    public void release() {
        try {
            if (Build.VERSION.SDK_INT >= 16 && this.mMediaCodec != null && this.mOutputBufferId > 0) {
                this.mMediaCodec.releaseOutputBuffer(this.mOutputBufferId, false);
                this.mMediaCodec = null;
                this.mOutputBufferId = 0;
            }
        }
        catch (Exception e) {
            Log.e((String)"MediaCodecData", (String)("releaseOutputBuffer error" + e.getMessage()));
            e.printStackTrace();
        }
        this.mCodecData = null;
    }

    @NativeUsed
    public boolean isEOS() {
        return this.isEos;
    }

    public void setEos(boolean eos) {
        this.isEos = eos;
    }

    public String toString() {
        return "MediaCodecData{mDataType=" + this.mDataType + ", mCode=" + this.mCode + ", mPts=" + this.mPts + ", mDts=" + this.mDts + '}';
    }
}

