/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.Log;
import android.util.Range;

public class VideoCodecInfo {
    final String mMimeType = "video/avc";
    public int mMaxBitrate = Integer.MAX_VALUE;
    public int mMinBitrate = 0;
    public int mMaxWidth = Integer.MAX_VALUE;
    public int mMinWidth = 0;
    public int mMaxHeight = Integer.MAX_VALUE;
    public int mMinHeight = 0;
    public int mWidthAlign = 16;
    public int mHeightAlign = 16;
    private static final String TAG = "VideoCodecInfo";
    public MediaCodecInfo.VideoCapabilities mVideoCapabilities = null;

    public VideoCodecInfo() {
        if (Build.VERSION.SDK_INT >= 21) {
            Log.i((String)TAG, (String)"try to got CodecCapabilities");
            MediaCodecInfo codecInfo = this.selectCodecInfo("video/avc");
            if (codecInfo == null) {
                Log.e((String)TAG, (String)"failed to got mediaCodecinfo video/avc");
                return;
            }
            MediaCodecInfo.CodecCapabilities cap = codecInfo.getCapabilitiesForType("video/avc");
            if (cap == null) {
                Log.e((String)TAG, (String)"failed to got CodecCapabilities video/avc");
                return;
            }
            this.mVideoCapabilities = cap.getVideoCapabilities();
            if (this.mVideoCapabilities == null) {
                Log.e((String)TAG, (String)"failed to got VideoCapabilities video/avc");
                return;
            }
            Range bitrateRange = this.mVideoCapabilities.getBitrateRange();
            this.mMaxBitrate = (Integer)bitrateRange.getUpper();
            this.mMinBitrate = (Integer)bitrateRange.getLower();
            this.mWidthAlign = this.mVideoCapabilities.getWidthAlignment();
            this.mHeightAlign = this.mVideoCapabilities.getHeightAlignment();
            Range widthRange = this.mVideoCapabilities.getSupportedWidths();
            this.mMaxWidth = (Integer)widthRange.getUpper();
            this.mMinWidth = (Integer)widthRange.getLower();
            Range heightRange = this.mVideoCapabilities.getSupportedHeights();
            this.mMaxHeight = (Integer)heightRange.getUpper();
            this.mMinHeight = (Integer)heightRange.getLower();
        }
        Log.e((String)TAG, (String)("bitrateRange [" + this.mMinBitrate + "," + this.mMaxBitrate + "], widthAlignment = " + this.mWidthAlign + ", heightAlignment = " + this.mHeightAlign + ", widthRange [" + this.mMinWidth + "," + this.mMaxWidth + "], heightRange [" + this.mMinHeight + "," + this.mMaxHeight + "]"));
    }

    public boolean isSizeSupported(int width, int height) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mVideoCapabilities != null) {
                return this.mVideoCapabilities.isSizeSupported(width, height);
            }
            return true;
        }
        return true;
    }

    public void getSupportProfile() {
    }

    public void getSupportFormats() {
    }

    private MediaCodecInfo selectCodecInfo(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return null;
    }
}

