import 'dart:convert';
import 'dart:io';
import 'dart:typed_data';
import 'package:flutter/services.dart';
import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/model/music_info.dart';
import 'package:path_provider/path_provider.dart';
import 'package:shared_preferences/shared_preferences.dart';

///推流设置页面类型 key
String pushConfigPageTypeKey = "push_config_page_type_key";

///推流模式
String pushMode = "push_mode_key";

///推流url key
String pushURLKey = "push_url_key";

///推流参数配置 key
String pushConfigKey = "push_config_key";

///推流美颜开关配置 key
String pushBeautyOnKey = "push_beauty_on_key";

///推流参数配置返回 key
String pushConfigOnSettingConfigActionKey =
    "push_config_on_setting_config_action_key";

String interactiveFromHomePageKey = "interactive_from_home_page_key";

///互动连麦 key
String interactiveTypeKey = "interactive_type_key";

///互动模式 appId key
String interactiveAppIdKey = "interactive_appId_key";

///互动模式 appKey key
String interactiveAppKeyKey = "interactive_appKey_key";

///互动模式 playDomain key
String interactivePlayDomainKey = "interactive_playDomain_key";

///互动模式身份 key
String interactiveIdentityKey = "interactive_identity_key";

String interactiveRoomIdKey = "interactive_room_id_key";
String interactiveUserIdKey = "interactive_user_id_key";

enum InteractiveTypeEnum {
  interactiveLive,
  interactivePK,
}

enum InteractiveIdentityTypeEnum {
  anchor,
  audience,
}

enum DirType {
  document,
  library,
  externalFile,
}

class DirPathData {
  bool exist = false;
  String path = "";
}

class ExternalStreamData {
  static const String videoRequstURL =
      "https://alivc-demo-cms.alicdn.com/versionProduct/resources/livePush/capture0.yuv";
  static const String downloadDir = "download";
  static const String videoResourceName = "capture0.yuv";
  static const String audioResourceName = "441.pcm";
}

List<MusicInfo> musicList = [
  MusicInfo(0, "no_music", ""),
  MusicInfo(1, "axol", "assets/sound/Axol.mp3"),
  MusicInfo(2, "pasdeDeux", "assets/sound/PasdeDeux.mp3"),
  MusicInfo(3, "pasdeDeux5s", "assets/sound/PasdeDeux5s.mp3"),
  MusicInfo(4, "online_music",
      "http://docs-aliyun.cn-hangzhou.oss.aliyun-inc.com/assets/attach/51991/cn_zh/1511776743437/JUST%202017.mp3"),
];

List<String> imgList = [
  "assets/images/pauseImg.png",
  "assets/images/pauseImg_land.png",
  "assets/images/poorNetworkImg.png",
  "assets/images/poorNetworkImg_land.png"
];

const int saveLogMaxPartFileSizeInKB = 100 * 1024 * 1024;

class CommonUtil {
  // 私有构造函数，防止实例化
  CommonUtil._();

  static SharedPreferences? _prefs = null;

  static init() async {
    _prefs = await SharedPreferences.getInstance();
  }

  static pushPage(BuildContext context, Widget route) {
    Navigator.push(context, MaterialPageRoute(builder: (context) => route));
  }

  static Future<String> setSaveDir(DirType dirType, String fileName,
      {String? dir}) async {
    String _path = await getSystemPath(dirType);
    if (dir != null && dir.length > 0) {
      _path = await _createDir(_path + "/" + dir);
    }
    _path = _path + "/" + fileName;
    return _path;
  }

  static Future<DirPathData> getSaveDir(DirType dirType, String fileName,
      {String? dir}) async {
    String _path = await getSystemPath(dirType);
    if (dir != null && dir.length > 0) {
      _path = _path + "/" + dir;
    }
    _path = _path + "/" + fileName;

    DirPathData _data = DirPathData();
    _data.path = _path;

    File file = File(_path);
    bool exist = await file.exists();
    if (exist) {
      _data.exist = true;
    }

    return _data;
  }

  static Future<String> getSystemPath(DirType dirType) async {
    String _path = "";
    switch (dirType) {
      case DirType.document:
        final dir = await getApplicationDocumentsDirectory();
        _path = dir.path;
        break;
      case DirType.library:
        final dir = await getLibraryDirectory();
        _path = dir.path;
        break;
      case DirType.externalFile:
        final dir = await getExternalStorageDirectory();
        _path = dir?.path ?? "";
        break;
    }
    return _path;
  }

  static Future<Uint8List> convertBytesAtAssetsResource(String fileName) async {
    var imageData = await rootBundle.load(fileName);
    var bytes = imageData.buffer
        .asUint8List(imageData.offsetInBytes, imageData.lengthInBytes);
    return bytes;
  }

  static Future<String> convertBase64StringAtAssetsResource(
      String fileName) async {
    var bytes = await convertBytesAtAssetsResource(fileName);
    return base64Encode(bytes);
  }

  static Future<bool> saveSystemDirWithAssetsResource(
      String resourceName, DirType dirType, String fileName,
      {String? dir}) async {
    String _systemDirPath = await setSaveDir(dirType, fileName, dir: dir);
    File file = File(_systemDirPath);
    var bytes = await convertBytesAtAssetsResource(resourceName);
    file = await file.writeAsBytes(bytes);
    bool exist = await file.exists();
    return exist;
  }

  static Future<String> _createDir(String dir) async {
    Directory directory = Directory(dir);
    if (!directory.existsSync()) {
      directory.createSync();
    }
    return directory.path;
  }

  static void saveLocal(String key, dynamic value) async {
    switch (value.runtimeType.toString()) {
      case "String":
        await _prefs?.setString(key, value);
        break;
      case "int":
        await _prefs?.setInt(key, value);
        break;
      case "double":
        await _prefs?.setDouble(key, value);
        break;
      case "bool":
        await _prefs?.setBool(key, value);
        break;
    }
  }

  static Object? getLocal(String key) {
    return _prefs?.get(key);
  }

  static void removeLocal(String key) async {
    await _prefs?.remove(key);
  }
}

class AlivcViewFrame {
  double x = 0.0;
  double y = 0.0;
  double width = 0.0;
  double height = 0.0;

  static AlivcViewFrame makeAll(
      double x, double y, double width, double height) {
    AlivcViewFrame frame = AlivcViewFrame();
    frame.x = x;
    frame.y = y;
    frame.width = width;
    frame.height = height;
    return frame;
  }

  static AlivcViewFrame makeOnly(
      {double? x, double? y, double? width, double? height}) {
    AlivcViewFrame frame = AlivcViewFrame();
    frame.x = x ?? 0.0;
    frame.y = y ?? 0.0;
    frame.width = width ?? 0.0;
    frame.height = height ?? 0.0;
    return frame;
  }
}
