import 'dart:async';

import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/page/home/middleware.dart';
import 'package:flutter_livepush_demo/page/home/page.dart';
import 'package:flutter_livepush_demo/page/home/reducer.dart';
import 'package:flutter_livepush_demo/page/home/state.dart';
import 'package:redux/redux.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';
import 'common/log_util.dart';

void main() {
  runZoned(() {
    runApp(const MyApp());
  }, onError: (error, stackTrace) {
    LogUtil.v('flutter error: ${error?.toString()}, ${stackTrace?.toString()}');
  });
}

class MyApp extends StatefulWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  void initState() {
    super.initState();
    LogUtil.init(isDebug: true, tag: 'flutter-livepush');
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: HomePage(
        store: Store<HomeState>(
          homeReducer,
          initialState: HomeState(),
          middleware: createHomeMiddlewares(),
        ),
      ),
      localizationsDelegates: AppLocalizations.localizationsDelegates,
      supportedLocales: const [
        Locale('en'),
        Locale('zh'),
      ],
    );
  }
}
