/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/1/23 10:33
 * @brief
 */
enum CameraPushActionType {
  initState,
  initListener,
  pushBeautyOnKey,
  previewCreated,
  clickPreview,
  clickePush,
  clickPausePush,
  clickReStartPush,
  showBeauty,
  hideBeauty,
  clickFlashLamp,
  clickSwitchCamera,
  clickSnapShot,
  goBackPage,
  updatePushStatusTip,
}

enum CameraPushBGMActionType {
  changeEars,
  changeAudioDenoise,
  changeMute,
  changePlayState,
  changeLoop,
  changeBGMVolume,
  changeCaptureVolume,
  changeBGMSource,
  updateBGMProgress,
  updateBGMDuration,
}

enum CameraPushConfigActionType {
  changePushMirror,
  changePreviewMirror,
  setPreviewDisplayMode,
  setTargetVideoBitrate,
  setMinVideoBitrate,
}

enum CameraPushBottomSheetActionType {
  showMusic,
  hideMusic,
  showMoreSetting,
  hideMoreSetting,
}

class CameraPushAction {
  final CameraPushActionType type;
  final dynamic payload;

  CameraPushAction(this.type, {this.payload});
}

class CameraPushBGMAction {
  final CameraPushBGMActionType type;
  final dynamic payload;

  CameraPushBGMAction(this.type, {this.payload});
}

class CameraPushConfigAction {
  final CameraPushConfigActionType type;
  final dynamic payload;

  CameraPushConfigAction(this.type, {this.payload});
}

class CameraPushBottomSheetAction {
  final CameraPushBottomSheetActionType type;
  final dynamic payload;

  CameraPushBottomSheetAction(this.type, {this.payload});
}
