import 'package:flutter_livepush_demo/page/camera_push/state.dart';
import 'package:redux/redux.dart';

import 'actions.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/1/23 10:33
 * @brief
 */
// middleware.dart
List<Middleware<CameraPushState>> createCameraPushStateMiddlewares() {
  return [
    TypedMiddleware<CameraPushState, CameraPushAction>(_receiveActions),
  ];
}

void _receiveActions(
  Store<CameraPushState> store,
  CameraPushAction action,
  NextDispatcher next,
) {
  if (action.type == CameraPushActionType.initState) {
    _initState(store);
  }
  next(action);
}

Future<void> _initState(
  Store<CameraPushState> store,
) async {}
